/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.common_classes;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.metal.MetalType;

public class CompatChestTexture {
    public static void generateChestTexture(ResourceSink sink, class_3300 manager, String shortenedID, MetalType metalType, class_2248 block, class_2960 normalRLoc, class_2960 maskRLoc, class_2960 overlayRLoc, class_2960 trappedORLoc) {
        CompatChestTexture.generateChestTexture(sink, manager, shortenedID, metalType, block, normalRLoc, maskRLoc, overlayRLoc, trappedORLoc, 2);
    }

    public static void generateChestTexture(ResourceSink sink, class_3300 manager, String shortenedID, MetalType metalType, class_2248 block, class_2960 normalRLoc, class_2960 maskRLoc, class_2960 overlayRLoc, class_2960 trappedORLoc, int removeDarkest) {
        try (TextureImage normalTexture = TextureImage.open((class_3300)manager, (class_2960)normalRLoc);
             TextureImage normalMask = TextureImage.open((class_3300)manager, (class_2960)maskRLoc);
             TextureImage normalOverlay = TextureImage.open((class_3300)manager, (class_2960)overlayRLoc);){
            TextureImage trapOverlay = trappedORLoc != null ? TextureImage.open((class_3300)manager, (class_2960)trappedORLoc) : null;
            Respriter respriterNormal = Respriter.masked((TextureImage)normalTexture, (TextureImage)normalMask);
            Respriter respriterOverlay = Respriter.of((TextureImage)normalOverlay);
            String path = "entity/chest/" + shortenedID + "/" + metalType.getAppendableId() + "_chest";
            String trapped_path = "entity/chest/" + shortenedID + "/" + metalType.getAppendableId() + "_trapped_chest";
            if (normalRLoc.toString().contains("left")) {
                path = path + "_left";
                trapped_path = trapped_path + "_left";
            } else if (normalRLoc.toString().contains("right")) {
                path = path + "_right";
                trapped_path = trapped_path + "_right";
            }
            try (TextureImage metalTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)metalType.getBlockOfThis("block")));){
                List metalPalette = Palette.fromAnimatedImage((TextureImage)metalTexture);
                McMetaFile plankMeta = metalTexture.getMcMeta();
                ArrayList<Palette> overlayPalette = new ArrayList<Palette>();
                for (Palette p : metalPalette) {
                    PaletteColor d1 = p.getDarkest();
                    PaletteColor d2 = p.getDarkest();
                    switch (removeDarkest) {
                        case 2: {
                            p.remove(d2);
                        }
                        case 1: {
                            p.remove(d1);
                        }
                    }
                    HCLColor n1 = new HCLColor(d1.hcl().hue(), d1.hcl().chroma() * 0.75f, d1.hcl().luminance() * 0.4f, d1.hcl().alpha());
                    HCLColor n2 = new HCLColor(d2.hcl().hue(), d2.hcl().chroma() * 0.75f, d2.hcl().luminance() * 0.6f, d2.hcl().alpha());
                    Palette pal = Palette.ofColors(List.of(n1, n2));
                    overlayPalette.add(pal);
                }
                class_2960 res = GemsRealm.res(path);
                if (!sink.alreadyHasTextureAtLocation(manager, res)) {
                    class_2960 trappedRes = GemsRealm.res(trapped_path);
                    CompatChestTexture.createChestTextures(sink, respriterNormal, respriterOverlay, plankMeta, metalPalette, overlayPalette, res, trappedRes, trapOverlay);
                }
            }
            catch (Exception ex) {
                GemsRealm.LOGGER.error("Failed to generate Chest block texture for for: {} - {}", (Object)block, (Object)ex);
            }
        }
        catch (Exception ex) {
            GemsRealm.LOGGER.error("Could not generate any Chest block texture: ", (Throwable)ex);
        }
    }

    private static void createChestTextures(ResourceSink sink, Respriter respriter, Respriter respriterO, McMetaFile baseMeta, List<Palette> basePalette, List<Palette> overlayPalette, class_2960 normalRLoc, class_2960 trappedRLoc, TextureImage trappedOverlay) {
        TextureImage recoloredBase = respriter.recolorWithAnimation(basePalette, baseMeta);
        TextureImage recoloredOverlay = respriterO.recolorWithAnimation(overlayPalette, baseMeta);
        recoloredBase.applyOverlay(new TextureImage[]{recoloredOverlay});
        if (trappedOverlay != null) {
            TextureImage trapped = recoloredBase.makeCopy();
            trapped.applyOverlay(new TextureImage[]{trappedOverlay.makeCopy()});
            sink.addTexture(trappedRLoc, trapped);
        }
        sink.addTexture(normalRLoc, recoloredBase);
    }
}

