/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.misc;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.configs.UnsafeDisablerConfigs;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;
import org.jetbrains.annotations.Nullable;

public class HardcodedMetalType
extends HardcodedBlockType {
    @Nullable
    public static Boolean isMetalBlockAlreadyRegistered(String entrySetId, String blockName, MetalType metalType, String modId) {
        blockIdentify = metalType.getId().toString();
        BlockTypeFromMod = metalType.getNamespace();
        supportedMod = modId;
        supportedBlockName = blockName;
        if (!PlatHelper.isModLoaded((String)"oreganized") && !PlatHelper.isModLoaded((String)"caverns_and_chasms") && HardcodedMetalType.isBlockRegistryFrom("minecraft", "", "minecraft:netherite", "nugget").booleanValue()) {
            return false;
        }
        if (UnsafeDisablerConfigs.metalTypeList.get().stream().anyMatch(blockIdentify::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.entrySetList.get().stream().anyMatch(entrySetId::matches)) {
            return true;
        }
        if (HardcodedMetalType.isKnownVanillaMetal(metalType)) {
            return true;
        }
        if (HardcodedMetalType.isMetalRegistryInTFC(metalType, supportedBlockName, "bars")) {
            return true;
        }
        if (HardcodedMetalType.isBlockRegistryFrom("minecraft", "", "tfc:gold", "nugget").booleanValue()) {
            return false;
        }
        return null;
    }

    public static boolean isMetalRegistryInTFC(MetalType metalType, String supportedBlockName, String childKey) {
        class_2248 block = metalType.getBlockOfThis(childKey);
        if (metalType.getNamespace().equals("tfc") && Objects.nonNull(block)) {
            String[] split = Utils.getID((class_2248)block).method_12832().split("/");
            String baseName = split[2] + "_" + childKey;
            return Objects.equals(baseName, supportedBlockName);
        }
        return false;
    }
}

