/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.modules.fabric.create;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.decoration.MetalScaffoldingCTBehaviour;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.xelbayria.gems_realm.api.GemsRealmModule;
import net.xelbayria.gems_realm.api.set.metal.MetalType;

@Environment(value=EnvType.CLIENT)
public class CreateClientModule {
    public static void registerWindowCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, class_2248> window, SimpleEntrySet<MetalType, class_2248> window_pane) {
        window.blocks.forEach((metalType, block) -> {
            String blockTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "palettes/ornate_", "window");
            CTSpriteShiftEntry spriteShift = CreateClientModule.vertical(blockTexture, blockTexture + "_connected");
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((class_2248)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new HorizontalCTBehaviour(spriteShift)));
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((class_2248)((class_2248)window_pane.blocks.get(metalType))), model -> new CTModel(model, (ConnectedTextureBehaviour)new GlassPaneCTBehaviour(spriteShift)));
        });
    }

    public static void registerCasingCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, class_2248> casing) {
        casing.blocks.forEach((metalType, block) -> {
            String blockTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing");
            String connectedTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing_connected");
            CTSpriteShiftEntry spriteShift = CreateClientModule.omni(blockTexture, connectedTexture);
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((class_2248)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new SimpleCTBehaviour(spriteShift)));
        });
    }

    public static void registerScaffoldCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, class_2248> scaffold) {
        scaffold.blocks.forEach((metalType, block) -> {
            String scaffoldTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold");
            String insideTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold_inside");
            String scaffoldCTM = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold_connected");
            String insideCTM = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold_inside_connected");
            String casingTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing");
            String casingCTM = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing_connected");
            CTSpriteShiftEntry scaffoldShift = CreateClientModule.horizontal(scaffoldTexture, scaffoldCTM);
            CTSpriteShiftEntry scaffoldInsideShift = CreateClientModule.horizontal(insideTexture, insideCTM);
            CTSpriteShiftEntry casingShift = CreateClientModule.omni(casingTexture, casingCTM);
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((class_2248)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new MetalScaffoldingCTBehaviour(scaffoldShift, scaffoldInsideShift, casingShift)));
        });
    }

    private static CTSpriteShiftEntry omni(String blockTexture, String connectedTexture) {
        return CTSpriteShifter.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, (class_2960)new class_2960(blockTexture), (class_2960)new class_2960(connectedTexture));
    }

    private static CTSpriteShiftEntry horizontal(String blockTexture, String connectedTexture) {
        return CTSpriteShifter.getCT((CTType)AllCTTypes.HORIZONTAL, (class_2960)new class_2960(blockTexture), (class_2960)new class_2960(connectedTexture));
    }

    private static CTSpriteShiftEntry vertical(String blockTexture, String connectedTexture) {
        return CTSpriteShifter.getCT((CTType)AllCTTypes.VERTICAL, (class_2960)new class_2960(blockTexture), (class_2960)new class_2960(connectedTexture));
    }
}

