/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.modules.fabric.create;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.decoration.MetalLadderBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingBlockItem;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorRenderer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.common_classes.RecipeUtility;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4970;
import net.minecraft.class_7924;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.GemsRealmEntrySet;
import net.xelbayria.gems_realm.api.GemsRealmModule;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.VanillaMetalTypes;
import net.xelbayria.gems_realm.modules.fabric.create.CreateClientModule;

public class CreateModule
extends GemsRealmModule {
    public final ItemOnlyEntrySet<MetalType, class_1792> sheet;
    public final SimpleEntrySet<MetalType, class_2248> casing;
    public final SimpleEntrySet<MetalType, class_2248> door;
    public final SimpleEntrySet<MetalType, class_2248> ladder;
    public final SimpleEntrySet<MetalType, class_2248> scaffolding;
    public final SimpleEntrySet<MetalType, class_2248> shingles;
    public final SimpleEntrySet<MetalType, class_2248> shingle_slab;
    public final SimpleEntrySet<MetalType, class_2248> shingle_stairs;
    public final SimpleEntrySet<MetalType, class_2248> tiles;
    public final SimpleEntrySet<MetalType, class_2248> tile_slab;
    public final SimpleEntrySet<MetalType, class_2248> tile_stairs;
    public final SimpleEntrySet<MetalType, class_2248> orante_window;
    public final SimpleEntrySet<MetalType, class_2248> ornate_window_pane;

    public CreateModule(String modId) {
        super(modId, "c");
        class_2960 tab = this.modRes("base");
        class_2960 paletteTab = this.modRes("palettes");
        this.sheet = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(MetalType.class, (String)"sheet", (Supplier)this.getModItem("iron_sheet"), () -> VanillaMetalTypes.IRON, metalType -> new class_1792(new class_1792.class_1793())).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("item/iron_sheet"))).addTag(new class_2960("forge:plates"), class_7924.field_41197)).setTabKey(tab)).build();
        this.addEntry((EntrySet)this.sheet);
        this.casing = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "casing", this.getModBlock("copper_casing"), () -> VanillaMetalTypes.COPPER, metalType -> new CasingBlock(Utils.copyPropertySafe((class_2248)metalType.block).method_9626(metalType.getSound()))).requiresChildren(new String[]{"ingot"})).addTextureM(this.modRes("block/copper_casing"), GemsRealm.res("block/c/copper_casing_m"))).addTextureM(this.modRes("block/copper_casing_connected"), GemsRealm.res("block/c/copper_casing_connected_m"))).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("casing"), class_7924.field_41254)).addTag(this.modRes("casing"), class_7924.field_41197)).setTabKey(tab)).build();
        this.addEntry((EntrySet)this.casing);
        this.door = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "door", this.getModBlock("copper_door"), () -> VanillaMetalTypes.COPPER, metalType -> SlidingDoorBlock.metal((class_4970.class_2251)Utils.copyPropertySafe((class_2248)metalType.block).method_9626(metalType.getSound()).method_22488(), (boolean)true)).requiresFromMap(this.casing.blocks)).addTile(this.getModTile("sliding_door")).setRenderType(RenderLayer.CUTOUT_MIPPED).generateBlockModels(true, new class_2960[]{this.modRes("block/copper_door/fold_left"), this.modRes("block/copper_door/fold_right")}).addTextureM(this.modRes("block/copper_door_bottom"), GemsRealm.res("block/c/copper_door_bottom_m"))).addTextureM(this.modRes("block/copper_door_side"), GemsRealm.res("block/c/copper_door_side_m"))).addTextureM(this.modRes("block/copper_door_top"), GemsRealm.res("block/c/copper_door_top_m"))).addTextureM(this.modRes("item/copper_door"), GemsRealm.res("item/c/copper_door_m"))).addTag(class_3481.field_33715, class_7924.field_41254)).setTabKey(tab)).addRecipe(this.modRes("crafting/kinetics/copper_door"))).copyParentDrop().build();
        this.addEntry((EntrySet)this.door);
        this.ladder = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "ladder", this.getModBlock("copper_ladder"), () -> VanillaMetalTypes.COPPER, metalType -> new MetalLadderBlock(Utils.copyPropertySafe((class_2248)metalType.block))).requiresChildren(new String[]{"ingot"})).setRenderType(RenderLayer.CUTOUT_MIPPED).addTexture(this.modRes("block/ladder_copper"))).addTexture(this.modRes("block/ladder_copper_hoop"))).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_22414, class_7924.field_41254)).addTag(class_3481.field_36327, class_7924.field_41254)).addTag(this.modRes("copycat_deny"), class_7924.field_41254)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.ladder);
        this.scaffolding = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "scaffolding", this.getModBlock("copper_scaffolding"), () -> VanillaMetalTypes.COPPER, metalType -> new MetalScaffoldingBlock(Utils.copyPropertySafe((class_2248)metalType.block))).requiresChildren(new String[]{"ingot"})).setRenderType(RenderLayer.CUTOUT_MIPPED).addTexture(this.modRes("block/scaffold/copper_scaffold"))).addTexture(this.modRes("block/scaffold/copper_scaffold_connected"))).addTexture(this.modRes("block/scaffold/copper_scaffold_inside"))).addTexture(this.modRes("block/scaffold/copper_scaffold_inside_connected"))).addTexture(this.modRes("block/funnel/copper_funnel_frame"))).addTag(class_3481.field_33715, class_7924.field_41254)).setTabKey(tab)).addCustomItem((metalType, block, properties) -> new MetalScaffoldingBlockItem(block, properties)).build();
        this.addEntry((EntrySet)this.scaffolding);
        this.shingles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "shingles", this.getModBlock("copper_shingles"), () -> VanillaMetalTypes.COPPER, metalType -> new class_2248(Utils.copyPropertySafe((class_2248)metalType.block))).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("block/copper/copper_shingles"))).addTexture(this.modRes("block/copper/copper_roof_top"))).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_33719, class_7924.field_41254)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.shingles);
        this.shingle_slab = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "shingle_slab", this.getModBlock("copper_shingle_slab"), () -> VanillaMetalTypes.COPPER, metalType -> new class_2482(Utils.copyPropertySafe((class_2248)metalType.block))).requiresFromMap(this.shingles.blocks)).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_33719, class_7924.field_41254)).addTag(class_3481.field_15469, class_7924.field_41254)).addTag(class_3489.field_15535, class_7924.field_41197)).setTabKey(tab)).defaultRecipe().addRecipe(this.modRes("copper_shingle_slab_from_copper_shingles_stonecutting"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.shingle_slab);
        this.shingle_stairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "shingle_stairs", this.getModBlock("copper_shingle_stairs"), () -> VanillaMetalTypes.COPPER, metalType -> new class_2510(metalType.block.method_9564(), Utils.copyPropertySafe((class_2248)metalType.block))).requiresFromMap(this.shingles.blocks)).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_33719, class_7924.field_41254)).addTag(class_3481.field_15459, class_7924.field_41254)).addTag(class_3489.field_15526, class_7924.field_41197)).setTabKey(tab)).defaultRecipe().addRecipe(this.modRes("copper_shingle_stairs_from_copper_shingles_stonecutting"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.shingle_stairs);
        this.tiles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "tiles", this.getModBlock("copper_tiles"), () -> VanillaMetalTypes.COPPER, metalType -> new class_2248(Utils.copyPropertySafe((class_2248)metalType.block))).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("block/copper/copper_tiles"))).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_33719, class_7924.field_41254)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.tiles);
        this.tile_slab = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "tile_slab", this.getModBlock("copper_tile_slab"), () -> VanillaMetalTypes.COPPER, metalType -> new class_2482(Utils.copyPropertySafe((class_2248)metalType.block))).requiresFromMap(this.tiles.blocks)).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_33719, class_7924.field_41254)).addTag(class_3481.field_15469, class_7924.field_41254)).addTag(class_3489.field_15535, class_7924.field_41197)).setTabKey(tab)).defaultRecipe().addRecipe(this.modRes("copper_tile_slab_from_copper_tiles_stonecutting"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.tile_slab);
        this.tile_stairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "tile_stairs", this.getModBlock("copper_tile_stairs"), () -> VanillaMetalTypes.COPPER, metalType -> new class_2510(metalType.block.method_9564(), Utils.copyPropertySafe((class_2248)metalType.block))).requiresFromMap(this.tiles.blocks)).addTag(class_3481.field_33715, class_7924.field_41254)).addTag(class_3481.field_33719, class_7924.field_41254)).addTag(class_3481.field_15459, class_7924.field_41254)).addTag(class_3489.field_15526, class_7924.field_41197)).setTabKey(tab)).defaultRecipe().addRecipe(this.modRes("copper_tile_stairs_from_copper_tiles_stonecutting"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.tile_stairs);
        this.orante_window = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "window", "ornate", this.getModBlock("ornate_iron_window"), () -> VanillaMetalTypes.IRON, this::makeWindow).addTextureM(this.modRes("block/palettes/ornate_iron_window"), GemsRealm.res("block/c/ornate_iron_window_m"))).addTexture(this.modRes("block/palettes/ornate_iron_window_end"))).addTextureM(this.modRes("block/palettes/ornate_iron_window_connected"), GemsRealm.res("block/c/ornate_iron_window_connected_m"))).setTabKey(paletteTab)).defaultRecipe().setRenderType(RenderLayer.TRANSLUCENT).build();
        this.addEntry((EntrySet)this.orante_window);
        this.ornate_window_pane = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "window_pane", "ornate", this.getModBlock("ornate_iron_window_pane"), () -> VanillaMetalTypes.IRON, metalType -> new ConnectedGlassPaneBlock(Utils.copyPropertySafe((class_2248)class_2246.field_10285))).requiresFromMap(this.orante_window.blocks)).addTexture(this.modRes("block/palettes/ornate_iron_window_pane_top"))).addTag(class_3481.field_15490, class_7924.field_41254)).addTag(new class_2960("forge:glass_panes"), class_7924.field_41254)).addTag(new class_2960("forge:glass_panes"), class_7924.field_41197)).setTabKey(paletteTab)).defaultRecipe().setRenderType(RenderLayer.TRANSLUCENT).copyParentDrop().build();
        this.addEntry((EntrySet)this.ornate_window_pane);
    }

    private WindowBlock makeWindow(MetalType metalType) {
        return new WindowBlock(Utils.copyPropertySafe((class_2248)class_2246.field_10033).method_26235((s, l, ps, t) -> false).method_26236((s, l, ps) -> false).method_26243((s, l, ps) -> false).method_26245((s, l, ps) -> false), false);
    }

    @Environment(value=EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        event.register(this.door.getTile(SlidingDoorBlockEntity.class), SlidingDoorRenderer::new);
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientSetup() {
        super.onClientSetup();
        CreateClientModule.registerCasingCTBehavior(this, this.casing);
        CreateClientModule.registerScaffoldCTBehavior(this, this.scaffolding);
        CreateClientModule.registerWindowCTBehavior(this, this.orante_window, this.ornate_window_pane);
    }

    public void onModSetup() {
        super.onModSetup();
        CreateModule.putFoldingDoor(this, this.door);
    }

    private static void putFoldingDoor(GemsRealmModule module, SimpleEntrySet<MetalType, class_2248> doors) {
    }

    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            String ladderRecipePath = "copper_ladder_from_ingots_copper_stonecutting";
            String scaffoldingRecipePath = "copper_scaffolding_from_ingots_copper_stonecutting";
            String shinglesRecipePath = "copper_shingles_from_ingots_copper_stonecutting";
            String tilesRecipePath = "copper_tiles_from_ingots_copper_stonecutting";
            this.ladder.blocks.forEach((metalType, block) -> {
                class_2960 ladderRecipeId = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "_ladder_from_ingots"));
                class_2960 scaffoldingRecipeId = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "_scaffolding_from_ingots"));
                class_2960 shinglesRecipeId = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "_shingles_from_ingots"));
                class_2960 tilesRecipeId = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "_tiles_from_ingots"));
                this.grabTagAndCreateRecipe(ladderRecipePath, ladderRecipeId, "copper", this.ladder.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(scaffoldingRecipePath, scaffoldingRecipeId, "copper", this.scaffolding.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(shinglesRecipePath, shinglesRecipeId, "copper", this.shingles.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(tilesRecipePath, tilesRecipeId, "copper", this.tiles.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
            });
            String pathLog = "item_application/copper_casing_from_log";
            String pathWood = "item_application/copper_casing_from_wood";
            this.casing.blocks.forEach((metalType, block) -> {
                class_2960 newResLocLog = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "item_application/", "casing_from_log"));
                class_2960 newResLocWood = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "item_application/", "casing_from_wood"));
                this.grabTagAndCreateRecipe(pathLog, newResLocLog, "copper", block, (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(pathWood, newResLocWood, "copper", block, (MetalType)((Object)((Object)metalType)), manager, sink);
            });
            String pathIngot = "pressing/iron_ingot";
            this.sheet.items.forEach((metalType, item) -> {
                class_2960 newResLocIngot = new class_2960(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "pressing/", "ingot"));
                this.grabTagAndCreateRecipe(pathIngot, newResLocIngot, "iron", item, (MetalType)((Object)((Object)metalType)), manager, sink);
            });
        });
    }

    public void grabTagAndCreateRecipe(String recipeLoc, class_2960 newRecipeLoc, String oldTypeName, Object newResult, MetalType metalType, class_3300 manager, ResourceSink sink) {
        String typeName = this.typeName(metalType);
        Pair newTagIngredient = TagUtility.getATagId((String)("forge:ingots/" + typeName), (String)("forge:ingots/" + typeName.replace("_", "")), (class_3300)manager);
        if (((Boolean)newTagIngredient.getSecond()).booleanValue()) {
            RecipeUtility.createRecipeWithTag((class_2960)this.modRes(recipeLoc), (class_2960)newRecipeLoc, (String)("forge:ingots/" + oldTypeName), (String)((class_2960)newTagIngredient.getFirst()).toString(), (Object)newResult, (ResourceSink)sink, (class_3300)manager);
        } else {
            GemsRealm.LOGGER.error("Failed to grab a tag for {}", (Object)Utils.getID((Object)newResult));
        }
    }

    public String typeName(MetalType metalType) {
        return switch (metalType.getId().toString()) {
            case "crystalcraft_unlimited_java:adamantite" -> "adamantium";
            case "crystalcraft_unlimited_java:silicium" -> "silicon";
            case "crystalcraft_unlimited_java:pottasium" -> "potassium";
            case "crystalcraft_unlimited_java:hydro_pottasium" -> "hydratedpotassium";
            case "crystalcraft_unlimited_java:unoptanium" -> "unobtanium";
            case "ms:refined_quartz" -> "quartz";
            default -> metalType.getTypeName();
        };
    }
}

