/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm;

import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.xelbayria.gems_realm.GRRegistry;
import net.xelbayria.gems_realm.api.intergration.CompatCrystalType;
import net.xelbayria.gems_realm.api.intergration.CompatDustType;
import net.xelbayria.gems_realm.api.intergration.CompatGemType;
import net.xelbayria.gems_realm.api.intergration.CompatMetalType;
import net.xelbayria.gems_realm.api.set.crystal.CrystalTypeRegistry;
import net.xelbayria.gems_realm.api.set.dust.DustTypeRegistry;
import net.xelbayria.gems_realm.api.set.gem.GemTypeRegistry;
import net.xelbayria.gems_realm.api.set.metal.MetalTypeRegistry;
import net.xelbayria.gems_realm.configs.GRConfigs;
import net.xelbayria.gems_realm.configs.UnsafeDisablerConfigs;
import net.xelbayria.gems_realm.misc.CompatSpriteHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GemsRealm
extends EveryCompat {
    public static final String MOD_ID = "gemsrealm";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gems Realm");

    public static void init() {
        GRConfigs.init();
        UnsafeDisablerConfigs.init();
        GRRegistry.init();
        CompatSpriteHelper.initHardcodedSprite();
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)CrystalTypeRegistry.INSTANCE);
        CompatCrystalType.init();
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)DustTypeRegistry.INSTANCE);
        CompatDustType.init();
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)MetalTypeRegistry.INSTANCE);
        CompatMetalType.init();
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)GemTypeRegistry.INSTANCE);
        CompatGemType.init();
    }

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    @SafeVarargs
    public static void addMultipleIfLoaded(String modId, Supplier<Function<String, CompatModule>> ... moduleFactories) {
        if (PlatHelper.isModLoaded((String)modId)) {
            for (Supplier<Function<String, CompatModule>> moduleFactory : moduleFactories) {
                CompatModule module = moduleFactory.get().apply(modId);
                GemsRealm.addModule((CompatModule)module);
            }
        }
    }
}

