/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.misc.CompatSpriteHelper;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemsRealmEntrySet<T extends BlockType, B extends Block>
extends SimpleEntrySet<T, B> {
    protected GemsRealmEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, @NotNull Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, SimpleEntrySet.LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable SimpleEntrySet.ITileHolder tileFactory, @Nullable Object renderType, @Nullable BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition, ModelConfiguration modelConfig) {
        super(type, name, prefix, blockSupplier, baseBlock, baseType, tab, tabMode, lootMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition, modelConfig);
        this.modelConfiguration = modelConfig;
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, ResourceManager manager) {
        String nameBaseRock = ((BlockType)this.baseType.get()).getTypeName();
        BlockTypeResTransformer transformer = BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager);
        if (Objects.nonNull(this.extraModelTransform)) {
            this.extraModelTransform.accept(transformer);
        }
        return transformer.replaceWithTextureFromChild("minecraft:block/anvil", "block").replaceWithTextureFromChild("minecraft:block/" + nameBaseRock + "_block", "block").replaceWithTextureFromChild("minecraft:block/raw_" + nameBaseRock + "_block", "raw_block").replaceWithTextureFromChild("minecraft:block/" + nameBaseRock + "_bricks", "bricks").replaceWithTextureFromChild("minecraft:block/smooth_" + nameBaseRock, "smooth").replaceWithTextureFromChild("minecraft:block/polished_" + nameBaseRock, "polished").replaceWithTextureFromChild("minecraft:block/mossy_" + nameBaseRock + "_bricks", "mossy_bricks").replaceWithTextureFromChild("minecraft:block/budding_" + nameBaseRock, "budding").andThen(super.makeModelTransformer(module, manager));
    }

    protected BlockTypeResTransformer<T> makeBlockStateTransformer(SimpleModule module, ResourceManager manager) {
        String nameBaseType = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).andThen(super.makeBlockStateTransformer(module, manager));
    }

    private String getChildModelId(String childkey, T stoneType, ResourceLocation blockId) {
        if (CompatSpriteHelper.modelID.containsKey(blockId)) {
            return CompatSpriteHelper.modelID.get(blockId);
        }
        return Utils.getID((Block)Objects.requireNonNull(stoneType.getBlockOfThis(childkey))).m_246208_("block/").toString();
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends SimpleEntrySet.Builder<T, B> {
        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType, baseBlock, blockFactory);
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> createPaletteFromBlock() {
            return (Builder)this.createPaletteFromChild("block");
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> createPaletteFromBricks() {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromChild((BlockType)blockType, (ResourceManager)manager, (String)"bricks", null, p -> {});
                    return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
                }
                PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromMainChild((BlockType)blockType, (ResourceManager)manager);
                return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
            });
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> createPaletteFromRockChild(String childKey) {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromChild((BlockType)blockType, (ResourceManager)manager, (String)childKey, null, p -> {});
                    return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
                }
                PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromMainChild((BlockType)blockType, (ResourceManager)manager);
                return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
            });
            return this;
        }

        public GemsRealmEntrySet<T, B> build() {
            if (this.tab == null && PlatHelper.isDev()) {
                throw new IllegalStateException("Tab for module " + this.name + " was null!");
            }
            this.copyParentTint();
            GemsRealmEntrySet entry = new GemsRealmEntrySet(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.copyTint, this.condition, this.modelConfig);
            entry.recipeLocations.addAll(this.recipes);
            entry.tags.putAll(this.tags);
            entry.textures.addAll(this.textures);
            return entry;
        }
    }
}

