/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.intergration;

import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompatBlockType {
    protected static final Set<String> childKeySafe = Set.of("block", "stairs", "slab", "wall", "button", "pressure_plate", "smooth_stone", "polished", "polished_stairs", "polished_slab", "bricks", "brick_stairs", "brick_slab", "brick_wall", "cracked_bricks", "brick_tiles", "mossy_bricks", "mossy_brick_slab", "mossy_brick_stairs", "mossy_brick_wall", "ingot", "nugget", "cluster", "budding", "shard", "dust");

    public static String getChildKeyFrom(String childBlock) {
        Pattern pattern;
        Matcher matcher;
        if (childBlock.contains("-")) {
            return childBlock.split("-")[0].toLowerCase();
        }
        String lastword = childBlock.substring(childBlock.lastIndexOf("_") + 1);
        if (childBlock.matches("\\w+(?:_bricks?)?(?:_[a-z]+)?") && (matcher = (pattern = Pattern.compile("\\w+(?<type>_bricks?)?(?<subtype>_[a-z]+)?")).matcher(childBlock)).find()) {
            String suffix;
            return switch (suffix = Objects.isNull(matcher.group("type")) ? matcher.group("type") : matcher.group("type") + matcher.group("subtype")) {
                case "brick", "bricks" -> "bricks";
                case "brick_slab", "bricks_slab" -> "brick_slab";
                case "brick_stairs", "bricks_stairs" -> "brick_stairs";
                case "brick_wall", "bricks_wall" -> "brick_wall";
                default -> lastword;
            };
        }
        return lastword;
    }
}

