/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set;

import java.util.ArrayList;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class RockType
extends BlockType {
    public final Block block;

    protected RockType(ResourceLocation id, Block block) {
        super(id);
        this.block = block;
    }

    protected void initializeChildrenBlocks() {
        this.addChild("block", this.block);
        this.addChild("raw_block", this.findRelatedBlock("raw", "block"));
        this.addChild("stairs", this.findChildBlocks("stair"));
        this.addChild("slab", this.findChildBlocks("slab"));
        this.addChild("fence", this.findChildBlocks("fence"));
        this.addChild("chiseled", this.findRelatedBlock("chiseled", ""));
        Block bricks = this.findBrickEntry("", "");
        this.addChild("bricks", bricks);
        if (bricks != null) {
            this.addChild("brick_stairs", this.findBrickEntry("", "stairs"));
            this.addChild("brick_slab", this.findBrickEntry("", "slab"));
            this.addChild("brick_wall", this.findBrickEntry("", "wall"));
            this.addChild("brick_tiles", this.findBrickEntry("", "tiles"));
            this.addChild("cracked_bricks", this.findBrickEntry("cracked", ""));
            this.addChild("mossy_bricks", this.findBrickEntry("mossy", ""));
            this.addChild("mossy_brick_slab", this.findBrickEntry("mossy", "slab"));
            this.addChild("mossy_brick_stairs", this.findBrickEntry("mossy", "stairs"));
            this.addChild("mossy_brick_wall", this.findBrickEntry("mossy", "wall"));
        }
        Block smooth = (Block)this.findRelatedEntry("smooth", (Registry)BuiltInRegistries.f_256975_);
        this.addChild("smooth", smooth);
        if (Objects.nonNull(smooth)) {
            this.addChild("smooth_stairs", this.findRelatedBlock("smooth", "stairs"));
            this.addChild("smooth_slab", this.findRelatedBlock("smooth", "slab"));
            this.addChild("smooth_wall", this.findRelatedBlock("smooth", "wall"));
        }
    }

    protected void initializeChildrenItems() {
    }

    @Nullable
    private Block findChildBlocks(String suffix) {
        Block first = (Block)this.findRelatedEntry("", suffix, (Registry)BuiltInRegistries.f_256975_);
        if (first != null) {
            return first;
        }
        return (Block)this.findRelatedEntry("", suffix + "s", (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    private Block findBrickEntry(String prefix, String suffix) {
        Object suffixed = suffix.isEmpty() ? "" : "_" + suffix;
        Block first = (Block)this.findRelatedEntry(prefix, "brick" + (String)suffixed, (Registry)BuiltInRegistries.f_256975_);
        if (first != null) {
            return first;
        }
        return (Block)this.findRelatedEntry(prefix, "bricks" + (String)suffixed, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    protected Block findRelatedBlock(String prefixOrInfix, String suffix) {
        return (Block)this.findRelatedEntry(prefixOrInfix, suffix, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    protected Item findRelatedItem(String prefixOrInfix, String suffix) {
        return (Item)this.findRelatedEntry(prefixOrInfix, suffix, (Registry)BuiltInRegistries.f_257033_);
    }

    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        Object prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object _suffix = suffix.isEmpty() ? "" : "_" + suffix;
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + (String)_infix + (String)_suffix), new ResourceLocation(this.id.m_135827_(), (String)prefix_ + this.id.m_135815_() + (String)_suffix), new ResourceLocation(this.id.m_135827_(), "gem/" + this.id.m_135815_() + (String)_suffix), new ResourceLocation(this.id.m_135827_(), "resources/" + (String)prefix_ + this.id.m_135815_() + (String)_suffix), new ResourceLocation(this.id.m_135827_(), suffix + "/" + this.id.m_135815_() + (String)_suffix), new ResourceLocation(this.id.m_135827_(), suffix + "/" + this.id.m_135815_() + suffix), new ResourceLocation(this.id.m_135827_(), suffix + "/" + this.id.m_135815_())};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    public ItemLike mainChild() {
        return this.block;
    }

    protected static ResourceLocation[] makeKnownIDConventions(ResourceLocation id, String ... affixKeyword) {
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        for (String keyword : affixKeyword) {
            String path = id.m_135815_();
            String namespace = id.m_135827_();
            Object suffixed = keyword.isEmpty() ? "" : "_" + keyword;
            Object prefixed = keyword.isEmpty() ? "" : keyword + "_";
            resources.add(new ResourceLocation(namespace, path + (String)suffixed));
            resources.add(new ResourceLocation(namespace, (String)prefixed + path));
        }
        return resources.toArray(new ResourceLocation[0]);
    }
}

