/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.crystal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.crystal.CrystalTypeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CrystalType
extends RockType {
    protected CrystalType(ResourceLocation id, Block blockCrystal) {
        super(id, blockCrystal);
    }

    public String getTranslationKey() {
        return "crystal_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        this.addChild("cluster", this.findRelatedBlock("", "cluster"));
        this.addChild("glinted_cluster", this.findRelatedBlock("glinted", "cluster"));
        this.addChild("lamp", this.findRelatedBlock("", "lamp"));
        this.addChild("budding", this.findRelatedBlock("budding", ""));
        super.initializeChildrenBlocks();
    }

    @Override
    protected void initializeChildrenItems() {
        this.addChild("shard", this.findRelatedItem("", "shard"));
    }

    @Override
    protected Block findRelatedBlock(String prefixOrInfix, String suffix) {
        return (Block)this.findRelatedEntry(prefixOrInfix, suffix, (Registry)BuiltInRegistries.f_256975_);
    }

    @Override
    protected Item findRelatedItem(String prefixOrInfix, String suffix) {
        return (Item)this.findRelatedEntry(prefixOrInfix, suffix, (Registry)BuiltInRegistries.f_257033_);
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        V block = super.findRelatedEntry(prefixOrInfix, suffix, reg);
        if (Objects.nonNull(block)) {
            return block;
        }
        Object prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object _suffix = suffix.isEmpty() ? "" : "_" + suffix;
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + (String)_infix + (String)_suffix), new ResourceLocation(this.id.m_135827_(), (String)prefix_ + this.id.m_135815_() + (String)_suffix)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    public static Block findCrystalBlock(ResourceLocation id) {
        ResourceLocation[] tests = CrystalType.makeKnownIDConventions(id, "block");
        return (Block)Utils.findFirstInRegistry((Registry)BuiltInRegistries.f_256975_, (ResourceLocation[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<CrystalType> {
        private Supplier<Block> blockCrystalFinder;

        public Finder(ResourceLocation id) {
            super(id, (BlockTypeRegistry)CrystalTypeRegistry.INSTANCE);
            this.crystalBlock(() -> CrystalType.findCrystalBlock(id));
        }

        public Finder crystalBlock(Supplier<Block> crystalFinder) {
            this.blockCrystalFinder = crystalFinder;
            return this;
        }

        public Finder crystalBlock(ResourceLocation id) {
            return this.crystalBlock(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find Crystal Block: " + String.valueOf(id))));
        }

        public Finder crystalBlock(String nameCrystalBlock) {
            return this.crystalBlock(Utils.idWithOptionalNamespace((String)nameCrystalBlock, (String)this.id.m_135827_()));
        }

        public Finder crystalBlockAffix(String prefix, String suffix) {
            return this.crystalBlock(prefix + this.id.m_135815_() + suffix);
        }

        public Finder crystalBlockSuffix(String suffix) {
            return this.crystalBlock(this.id.m_135815_() + suffix);
        }

        @ApiStatus.Internal
        public Optional<CrystalType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block crystal = (Block)Preconditions.checkNotNull((Object)this.blockCrystalFinder.get(), (String)"Manual Finder - failed to find a Crystal Block for {}", (Object)this.id);
                    CrystalType crystalType = new CrystalType(this.id, crystal);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            crystalType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for CrystalType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(crystalType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom CrystalType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

