/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.crystal;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.api.set.crystal.CrystalType;
import net.xelbayria.gems_realm.api.set.crystal.VanillaCrystalTypes;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;

public class CrystalTypeRegistry
extends BlockTypeRegistry<CrystalType> {
    public static final CrystalTypeRegistry INSTANCE = new CrystalTypeRegistry();

    public CrystalTypeRegistry() {
        super(CrystalType.class, "crystal_type");
    }

    public CrystalType register(CrystalType vanillaType) {
        return (CrystalType)super.register((BlockType)vanillaType);
    }

    public CrystalType getDefaultType() {
        return VanillaCrystalTypes.AMETHYST;
    }

    public Optional<CrystalType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseRes) {
        String blockPath = baseRes.m_135815_();
        if (blockPath.matches("\\w+_block")) {
            Optional opt;
            boolean noGemType;
            String crystalName = blockPath.replace("_block", "");
            ResourceLocation idBlockType = baseRes.m_247449_(crystalName);
            boolean hasShard = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "shard")));
            boolean hasCluster = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "cluster")));
            boolean noWoodType = !BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "log")));
            boolean noMetalType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ingot")));
            boolean bl = noGemType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("_block", "")));
            if (!this.valuesReg.containsKey(idBlockType) && (hasCluster || hasShard) && noWoodType && noMetalType && noGemType && !HardcodedBlockType.BLACKLISTED_CRYSTALTYPES.contains(idBlockType.toString()) && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_()) && (opt = BuiltInRegistries.f_256975_.m_6612_(baseRes)).isPresent()) {
                return Optional.of(new CrystalType(idBlockType, (Block)opt.get()));
            }
        }
        return Optional.empty();
    }

    public CrystalType.Finder addSimpleFinder(ResourceLocation crystalTypeId) {
        CrystalType.Finder finder = new CrystalType.Finder(crystalTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public CrystalType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new ResourceLocation(typeId));
    }

    public CrystalType.Finder addSimpleFinder(String namespace, String nameCrystalType) {
        return this.addSimpleFinder(new ResourceLocation(namespace, nameCrystalType));
    }

    public int priority() {
        return 110;
    }
}

