/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.dust;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.dust.DustTypeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DustType
extends RockType {
    protected DustType(ResourceLocation id, Block blockDust) {
        super(id, blockDust);
    }

    public String getTranslationKey() {
        return "dust_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
    }

    @Override
    protected void initializeChildrenItems() {
        this.addChild("dust", this.findRelatedItem("", "dust"));
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        V block = super.findRelatedEntry(prefixOrInfix, suffix, reg);
        if (Objects.nonNull(block)) {
            return block;
        }
        Object prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object _suffix = suffix.isEmpty() ? "" : "_" + suffix;
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + (String)_infix + (String)_suffix), new ResourceLocation(this.id.m_135827_(), (String)prefix_ + this.id.m_135815_() + (String)_suffix)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    public static Block findDustBlock(ResourceLocation id) {
        ResourceLocation[] tests = DustType.makeKnownIDConventions(id, "dust");
        return (Block)Utils.findFirstInRegistry((Registry)BuiltInRegistries.f_256975_, (ResourceLocation[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<DustType> {
        private Supplier<Block> blockDustFinder;

        public Finder(ResourceLocation id) {
            super(id, (BlockTypeRegistry)DustTypeRegistry.INSTANCE);
            this.dustBlock(() -> DustType.findDustBlock(id));
        }

        public Finder dustBlock(Supplier<Block> dustFinder) {
            this.blockDustFinder = dustFinder;
            return this;
        }

        public Finder dustBlock(ResourceLocation id) {
            return this.dustBlock(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find Dust Block: " + String.valueOf(id))));
        }

        public Finder dustBlock(String nameDustBlock) {
            return this.dustBlock(Utils.idWithOptionalNamespace((String)nameDustBlock, (String)this.id.m_135827_()));
        }

        public Finder dustBlockAffix(String prefix, String suffix) {
            return this.dustBlock(prefix + this.id.m_135815_() + suffix);
        }

        public Finder dustBlockSuffix(String suffix) {
            return this.dustBlock(this.id.m_135815_() + suffix);
        }

        @ApiStatus.Internal
        public Optional<DustType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block dust = (Block)Preconditions.checkNotNull((Object)this.blockDustFinder.get(), (String)"Manual Finder - failed to find a Dust Block for {}", (Object)this.id);
                    DustType dustType = new DustType(this.id, dust);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            dustType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for DustType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(dustType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom DustType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

