/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.dust;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.api.set.dust.DustType;
import net.xelbayria.gems_realm.api.set.dust.VanillaDustTypes;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;

public class DustTypeRegistry
extends BlockTypeRegistry<DustType> {
    public static final DustTypeRegistry INSTANCE = new DustTypeRegistry();

    public DustTypeRegistry() {
        super(DustType.class, "dust_type");
    }

    public DustType register(DustType vanillaType) {
        return (DustType)super.register((BlockType)vanillaType);
    }

    public DustType getDefaultType() {
        return VanillaDustTypes.REDSTONE;
    }

    public Optional<DustType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseRes) {
        String blockPath = baseRes.m_135815_();
        if (blockPath.matches("\\w+_block")) {
            Optional opt;
            boolean noGemType;
            String crystalName = blockPath.replace("_block", "");
            ResourceLocation idBlockType = baseRes.m_247449_(crystalName);
            boolean hasDust = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "dust")));
            boolean noWoodType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "log")));
            boolean noMetalType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ingot")));
            boolean bl = noGemType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("_block", "")));
            if (!this.valuesReg.containsKey(idBlockType) && hasDust && noWoodType && noMetalType && noGemType && !HardcodedBlockType.BLACKLISTED_DUSTTYPES.contains(idBlockType.toString()) && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_()) && !HardcodedBlockType.BLACKLISTED_DUST_MODS.contains(baseRes.m_135827_()) && (opt = BuiltInRegistries.f_256975_.m_6612_(baseRes)).isPresent()) {
                return Optional.of(new DustType(idBlockType, (Block)opt.get()));
            }
        }
        return Optional.empty();
    }

    public DustType.Finder addSimpleFinder(ResourceLocation dustTypeId) {
        DustType.Finder finder = new DustType.Finder(dustTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public DustType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new ResourceLocation(typeId));
    }

    public DustType.Finder addSimpleFinder(String namespace, String nameDustType) {
        return this.addSimpleFinder(new ResourceLocation(namespace, nameDustType));
    }

    public int priority() {
        return 110;
    }
}

