/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.gem;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.gem.GemTypeRegistry;
import org.jetbrains.annotations.ApiStatus;

public class GemType
extends RockType {
    protected GemType(ResourceLocation id, Block blockGem) {
        super(id, blockGem);
    }

    public String getTranslationKey() {
        return "gem_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
    }

    @Override
    protected void initializeChildrenItems() {
        super.initializeChildrenItems();
        this.addChild("gem", this.findRelatedItem("", ""));
    }

    public static Block findGemBlock(ResourceLocation id) {
        ResourceLocation[] tests = GemType.makeKnownIDConventions(id, "block");
        return (Block)Utils.findFirstInRegistry((Registry)BuiltInRegistries.f_256975_, (ResourceLocation[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<GemType> {
        private Supplier<Block> blockGemFinder;

        public Finder(ResourceLocation id) {
            super(id, (BlockTypeRegistry)GemTypeRegistry.INSTANCE);
            this.gemBlock(() -> GemType.findGemBlock(id));
        }

        public Finder gemBlock(Supplier<Block> gemFinder) {
            this.blockGemFinder = gemFinder;
            return this;
        }

        public Finder gemBlock(ResourceLocation id) {
            return this.gemBlock(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find Gem Block: " + String.valueOf(id))));
        }

        public Finder gemBlock(String nameGemBlock) {
            return this.gemBlock(Utils.idWithOptionalNamespace((String)nameGemBlock, (String)this.id.m_135827_()));
        }

        public Finder gemBlockAffix(String prefix, String suffix) {
            return this.gemBlock(prefix + this.id.m_135815_() + suffix);
        }

        public Finder gemBlockSuffix(String suffix) {
            return this.gemBlock(this.id.m_135815_() + suffix);
        }

        @ApiStatus.Internal
        public Optional<GemType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block gem = (Block)Preconditions.checkNotNull((Object)this.blockGemFinder.get(), (String)"Manual Finder - failed to find a Gem Block for {}", (Object)this.id);
                    GemType gemType = new GemType(this.id, gem);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            gemType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for GemType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(gemType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom GemType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

