/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.gem;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.api.set.gem.GemType;
import net.xelbayria.gems_realm.api.set.gem.VanillaGemTypes;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;

public class GemTypeRegistry
extends BlockTypeRegistry<GemType> {
    public static final GemTypeRegistry INSTANCE = new GemTypeRegistry();

    public GemTypeRegistry() {
        super(GemType.class, "gem_type");
    }

    public GemType register(GemType vanillaType) {
        return (GemType)super.register((BlockType)vanillaType);
    }

    public GemType getDefaultType() {
        return VanillaGemTypes.EMERALD;
    }

    public Optional<GemType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String blockPath = baseRes.m_135815_();
        if (blockPath.matches("^(?:rare|dark|black|white|cyan|pink|yellow|blue|green|purple|red|orange|brown|olive)?_?(?:ice|fire|star|blue)?_?[a-z]+_block$")) {
            Optional opt;
            boolean noMetalType;
            String gemName = blockPath.replace("_block", "");
            ResourceLocation idBlockType = baseRes.m_247449_(gemName);
            boolean hasOre = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ore"))) || BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), "deepslate_" + blockPath.replace("block", "ore")));
            boolean hasGem = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("_block", "")));
            boolean noWoodType = !BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "log")));
            boolean noCrystalType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "cluster")));
            boolean noDustType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "dust")));
            boolean bl = noMetalType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ingot"))) && !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), "raw_" + blockPath.replace("_block", "")));
            if (!this.valuesReg.containsKey(idBlockType) && hasOre && hasGem && noWoodType && noCrystalType && noDustType && noMetalType && !HardcodedBlockType.BLACKLISTED_GEMTYPES.contains(idBlockType.toString()) && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_()) && (opt = BuiltInRegistries.f_256975_.m_6612_(baseRes)).isPresent()) {
                return Optional.of(new GemType(idBlockType, (Block)opt.get()));
            }
        }
        return Optional.empty();
    }

    public GemType.Finder addSimpleFinder(ResourceLocation gemTypeId) {
        GemType.Finder finder = new GemType.Finder(gemTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public GemType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new ResourceLocation(typeId));
    }

    public GemType.Finder addSimpleFinder(String namespace, String nameGemType) {
        return this.addSimpleFinder(new ResourceLocation(namespace, nameGemType));
    }

    public int priority() {
        return 110;
    }
}

