/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.metal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.metal.MetalTypeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MetalType
extends RockType {
    protected MetalType(ResourceLocation id, Block block) {
        super(id, block);
    }

    public String getTranslationKey() {
        return "metal_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
        this.addChild("trapdoor", this.findRelatedBlock("", "trapdoor"));
        this.addChild("lamp", this.findRelatedBlock("", "lamp"));
        this.addChild("chain", this.findRelatedBlock("", "chain"));
        this.addChild("anvil", this.findRelatedBlock("", "anvil"));
        this.addChild("bars", this.findRelatedBlock("", "bars"));
    }

    @Override
    protected void initializeChildrenItems() {
        this.addChild("ingot", this.findRelatedItem("", "ingot"));
        this.addChild("nugget", this.findRelatedItem("", "nugget"));
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        V block = super.findRelatedEntry(prefixOrInfix, (String)suffix, reg);
        if (Objects.nonNull(block)) {
            return block;
        }
        if (this.getId().m_135827_().matches("tfc|afc")) {
            Object prefix = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
            String withoutUnderscore = suffix;
            if (!((String)suffix).isEmpty()) {
                suffix = "_" + (String)suffix;
            }
            ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), "metal/" + (String)prefix + withoutUnderscore + "/" + this.id.m_135815_()), new ResourceLocation(this.id.m_135827_(), "metal/" + prefixOrInfix + "/" + this.id.m_135815_() + (String)suffix)};
            Object found = null;
            for (ResourceLocation r : targets) {
                if (!reg.m_7804_(r)) continue;
                found = reg.m_7745_(r);
                break;
            }
            return (V)found;
        }
        return null;
    }

    public static Block findMetalBlock(ResourceLocation id) {
        ResourceLocation[] tests = MetalType.makeKnownIDConventions(id, "block");
        return (Block)Utils.findFirstInRegistry((Registry)BuiltInRegistries.f_256975_, (ResourceLocation[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<MetalType> {
        private Supplier<Block> blockMetalFinder;

        public Finder(ResourceLocation id) {
            super(id, (BlockTypeRegistry)MetalTypeRegistry.INSTANCE);
            this.metalBlock(() -> MetalType.findMetalBlock(id));
        }

        public Finder metalBlock(Supplier<Block> metalFinder) {
            this.blockMetalFinder = metalFinder;
            return this;
        }

        public Finder metalBlock(ResourceLocation id) {
            return this.metalBlock(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find Metal Block: " + String.valueOf(id))));
        }

        public Finder metalBlock(String nameMetalBlock) {
            return this.metalBlock(Utils.idWithOptionalNamespace((String)nameMetalBlock, (String)this.id.m_135827_()));
        }

        public Finder metalBlockAffix(String prefix, String suffix) {
            return this.metalBlock(prefix + this.id.m_135815_() + suffix);
        }

        public Finder metalBlockSuffix(String suffix) {
            return this.metalBlock(this.id.m_135815_() + suffix);
        }

        @ApiStatus.Internal
        public Optional<MetalType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block metal = (Block)Preconditions.checkNotNull((Object)this.blockMetalFinder.get(), (String)"Manual Finder - failed to find a Metal Block for {}", (Object)this.id);
                    MetalType metalType = new MetalType(this.id, metal);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            metalType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for MetalType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(metalType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom MetalType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

