/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.metal;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.VanillaMetalTypes;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;

public class MetalTypeRegistry
extends BlockTypeRegistry<MetalType> {
    public static final MetalTypeRegistry INSTANCE = new MetalTypeRegistry();

    public MetalTypeRegistry() {
        super(MetalType.class, "metal_type");
    }

    public MetalType register(MetalType vanillaType) {
        return (MetalType)super.register((BlockType)vanillaType);
    }

    public MetalType getDefaultType() {
        return VanillaMetalTypes.IRON;
    }

    public Optional<MetalType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String metalName;
        int index;
        String blockPath = baseRes.m_135815_();
        if (baseRes.m_135827_().matches("tfc|afc") && blockPath.matches("metal/block/\\w+(?<!slab|stairs)")) {
            index = blockPath.lastIndexOf("/");
            metalName = blockPath.substring(index + 1);
            Optional block = BuiltInRegistries.f_256975_.m_6612_(baseRes);
            boolean hasIngot = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ingot")));
            if (block.isPresent() && hasIngot) {
                return Optional.of(new MetalType(baseRes.m_247449_(metalName), (Block)block.get()));
            }
        }
        if (baseRes.m_135827_().matches("ms") && blockPath.matches("resources/[a-z]+_block")) {
            boolean isBlacklisted;
            index = blockPath.lastIndexOf("/");
            metalName = blockPath.substring(index + 1).replace("_block", "");
            ResourceLocation idBlockType = baseRes.m_247449_(metalName);
            Optional block = BuiltInRegistries.f_256975_.m_6612_(baseRes);
            boolean hasIngot = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ingot").replace("resources", "gem")));
            boolean bl = isBlacklisted = !HardcodedBlockType.BLACKLISTED_METALTYPES.contains(idBlockType.toString());
            if (block.isPresent() && hasIngot && isBlacklisted) {
                return Optional.of(new MetalType(idBlockType, (Block)block.get()));
            }
        }
        if (blockPath.matches("\\w+_block")) {
            Optional opt;
            boolean noGemType;
            String metalName2 = blockPath.replace("_block", "");
            ResourceLocation idBlockType = baseRes.m_247449_(metalName2);
            boolean hasIngot = BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "ingot")));
            boolean noWoodType = !BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("block", "log")));
            boolean bl = noGemType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("_block", "")));
            if (!this.valuesReg.containsKey(idBlockType) && hasIngot && noWoodType && noGemType && !HardcodedBlockType.BLACKLISTED_METALTYPES.contains(idBlockType.toString()) && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_()) && (opt = BuiltInRegistries.f_256975_.m_6612_(baseRes)).isPresent()) {
                return Optional.of(new MetalType(idBlockType, (Block)opt.get()));
            }
        }
        return Optional.empty();
    }

    public MetalType.Finder addSimpleFinder(ResourceLocation metalTypeId) {
        MetalType.Finder finder = new MetalType.Finder(metalTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public MetalType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new ResourceLocation(typeId));
    }

    public MetalType.Finder addSimpleFinder(String namespace, String nameMetalType) {
        return this.addSimpleFinder(new ResourceLocation(namespace, nameMetalType));
    }

    public int priority() {
        return 110;
    }
}

