/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.common_classes;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.MetalTypeRegistry;
import net.xelbayria.gems_realm.api.set.metal.VanillaMetalTypes;
import net.xelbayria.gems_realm.common_classes.CompatTrappedChestBlock;
import org.jetbrains.annotations.NotNull;

public class CompatChestBlockEntity
extends ChestBlockEntity {
    private final MetalType metalType;
    private final boolean trapped;
    private float[] tint = null;

    public CompatChestBlockEntity(BlockEntityType<?> arg, BlockPos pos, BlockState state) {
        super(arg, pos, state);
        MetalType stone = (MetalType)MetalTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)state.m_60734_());
        this.metalType = stone == null ? VanillaMetalTypes.IRON : stone;
        this.trapped = state.m_60734_() instanceof CompatTrappedChestBlock;
    }

    public float[] getTint() {
        if (this.tint == null) {
            int color = Minecraft.m_91087_().m_91298_().m_92577_(Objects.requireNonNull(this.metalType.getBlockOfThis("block")).m_49966_(), (BlockAndTintGetter)this.f_58857_, this.f_58858_, 0);
            this.tint = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f};
        }
        return this.tint;
    }

    public MetalType getStoneType() {
        return this.metalType;
    }

    protected void m_142151_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, int eventId, int eventParam) {
        super.m_142151_(level, pos, state, eventId, eventParam);
        if (this.trapped && eventId != eventParam) {
            Block block = state.m_60734_();
            level.m_46672_(pos, block);
            level.m_46672_(pos.m_7495_(), block);
        }
    }

    public boolean isTrapped() {
        return this.trapped;
    }
}

