/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.common_classes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.MetalTypeRegistry;
import net.xelbayria.gems_realm.common_classes.CompatChestBlockEntity;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CompatChestBlockRenderer
extends ChestRenderer<CompatChestBlockEntity> {
    public static final ResourceLocation CHEST_SHEET = new ResourceLocation("textures/atlas/chest.png");
    private final Map<MetalType, Material> single = new HashMap<MetalType, Material>();
    private final Map<MetalType, Material> left = new HashMap<MetalType, Material>();
    private final Map<MetalType, Material> right = new HashMap<MetalType, Material>();
    private final Map<MetalType, Material> trapped = new HashMap<MetalType, Material>();
    private final Map<MetalType, Material> trapped_left = new HashMap<MetalType, Material>();
    private final Map<MetalType, Material> trapped_right = new HashMap<MetalType, Material>();

    public CompatChestBlockRenderer(BlockEntityRendererProvider.Context context, String shortenedId) {
        super(context);
        Iterator iterator = MetalTypeRegistry.INSTANCE.iterator();
        while (iterator.hasNext()) {
            MetalType metalType = (MetalType)((Object)iterator.next());
            if (HardcodedBlockType.isKnownVanillaMetal(metalType)) continue;
            String path = "entity/chest/" + shortenedId + "/" + metalType.getAppendableId() + "_chest";
            String trapped_path = "entity/chest/" + shortenedId + "/" + metalType.getAppendableId() + "_trapped_chest";
            if (metalType.isVanilla()) continue;
            this.single.put(metalType, new Material(CHEST_SHEET, GemsRealm.res(path)));
            this.left.put(metalType, new Material(CHEST_SHEET, GemsRealm.res(path + "_left")));
            this.right.put(metalType, new Material(CHEST_SHEET, GemsRealm.res(path + "_right")));
            this.trapped.put(metalType, new Material(CHEST_SHEET, GemsRealm.res(trapped_path)));
            this.trapped_left.put(metalType, new Material(CHEST_SHEET, GemsRealm.res(trapped_path + "_left")));
            this.trapped_right.put(metalType, new Material(CHEST_SHEET, GemsRealm.res(trapped_path + "_right")));
        }
    }

    @NotNull
    protected Material getMaterial(CompatChestBlockEntity blockEntity, ChestType chestType) {
        MetalType w = blockEntity.getStoneType();
        if (blockEntity.isTrapped()) {
            return switch (chestType) {
                case ChestType.LEFT -> this.trapped_left.get((Object)w);
                case ChestType.RIGHT -> this.trapped_right.get((Object)w);
                default -> this.trapped.get((Object)w);
            };
        }
        return switch (chestType) {
            case ChestType.LEFT -> this.left.get((Object)w);
            case ChestType.RIGHT -> this.right.get((Object)w);
            default -> this.single.get((Object)w);
        };
    }

    public void render(CompatChestBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block flag1 = blockstate.m_60734_();
        if (flag1 instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)flag1;
            boolean flag1x = chesttype != ChestType.SINGLE;
            poseStack.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.m_5641_(blockstate, level, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)blockEntity))).get(partialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material material = this.getMaterial(blockEntity, chesttype);
            VertexConsumer vertexconsumer = material.m_119194_(buffer, RenderType::m_110452_);
            float[] color = blockEntity.getTint();
            if (flag1x) {
                if (chesttype == ChestType.LEFT) {
                    this.render(poseStack, vertexconsumer, this.f_112353_, this.f_112355_, this.f_112354_, f1, i, packedOverlay, color);
                } else {
                    this.render(poseStack, vertexconsumer, this.f_112356_, this.f_112358_, this.f_112357_, f1, i, packedOverlay, color);
                }
            } else {
                this.render(poseStack, vertexconsumer, this.f_112350_, this.f_112352_, this.f_112351_, f1, i, packedOverlay, color);
            }
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay, float[] color) {
        lockPart.f_104203_ = lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        lidPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
        lockPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
        bottomPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
    }

    public static void register(ClientHelper.BlockEntityRendererEvent event, BlockEntityType<CompatChestBlockEntity> tile, String s) {
        event.register(tile, c -> new CompatChestBlockRenderer(c, s));
    }
}

