/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.configs;

import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.minecraft.resources.ResourceLocation;
import net.xelbayria.gems_realm.GemsRealm;

public class UnsafeDisablerConfigs {
    public static Supplier<List<String>> crystalTypeList;
    public static Supplier<List<String>> dustTypeList;
    public static Supplier<List<String>> gemTypeList;
    public static Supplier<List<String>> metalTypeList;
    public static Supplier<List<String>> entrySetList;
    public static ConfigSpec CONFIG_SPEC;

    public static void init() {
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((ResourceLocation)GemsRealm.res("hazardous"), (ConfigType)ConfigType.COMMON);
        String comment = "    \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 Attention \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n    Don't use this if you don't know what you are doing\n        REASON:\n    This file is a conditional registration. This is harmless in Singleplayer World,\n    but harmful in SERVER because you won't able to join.\n\n    \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 Detail \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n    This file allow you to exclude StoneTypes, MudType, EntrySet, or a Module\n    1) You can find their names for StoneTypes, MudType, or EntrySet in `everycomp-entries.toml`\n    2) Leave a value empty to disable that rule.\n\n    Module - is a Supported Mod, just a modId is sufficient.\n    EntrySet - is a FurnitureType or DecorativeType that Stone-Zone is supporting via the mod. it is either block or item.\n\n    NOTE: blacklisting a Module will be applied to Wood-Good, Stone-Zone, Gems-Realm - if you want to blacklist, then use everycomp-hazardous.toml\n";
        builder.comment(comment);
        builder.push("crystaltype");
        String crystalTypeExample = "    EXAMPLE: blacklist = [\n        \"forestry:.*fireproof.*\",\t\tCOMMENT: .* is an RegEx, it exclude all of CrystalType containing \"fireproof\" from Forestry\n        \"biomesoplenty:.*\",\t\t\t\tCOMMENT: .* is an RegEx, it exclude all of CrystalType from Wood Mod for any Module\n        \"biomesoplenty:redwood\"\t\tCOMMENT: exclude redwood from Wood Mod for any module\n    ]\n";
        crystalTypeList = builder.comment("Exclude CrystalType from all of Modules\n" + crystalTypeExample).define("blacklist", List.of());
        builder.pop();
        builder.push("dusttype");
        dustTypeList = builder.comment("Exclude DustType from all of Modules\n\tThe example is same as CrystalType's").define("blacklist", List.of());
        builder.pop();
        builder.push("gemtype");
        gemTypeList = builder.comment("Exclude GemType from all of Modules\n\tThe example is same as CrystalType's").define("blacklist", List.of());
        builder.pop();
        builder.push("metaltype");
        metalTypeList = builder.comment("Exclude MetalType from all of Modules\n\tThe example is same as CrystalType's").define("blacklist", List.of());
        builder.pop();
        builder.push("entryset");
        String entrysetExample = "    This is only applied to Gems-Realm.\n    EXAMPLE: blacklist = [\n        \"chipped:checkered_trapdoor\",\tCOMMENT: chipped:checkered_oak_trapdoor without \"oak\"\n        \"variantvanillablocks:chest\",\tCOMMENT: variantvanillablocks:oak_chest without \"oak\"\n        \"chipped:.*\"\t\t\t\t\tCOMMENT: .* is an regex which will exclude all of EntrySets from one Module\n    ]\n";
        entrySetList = builder.comment("Exclude EntrySet from the module for All of CrystalType, DustType, GemType, MetalType\n" + entrysetExample).define("blacklist", List.of());
        builder.pop();
        builder.setSynced();
        CONFIG_SPEC = builder.buildAndRegister();
        CONFIG_SPEC.loadFromFile();
        if (!(crystalTypeList.get().isEmpty() && dustTypeList.get().isEmpty() && gemTypeList.get().isEmpty() && metalTypeList.get().isEmpty() && entrySetList.get().isEmpty())) {
            EveryCompat.LOGGER.warn("        \n\n        ============================================================\n        |                                                          |\n        |                        ATTENTION                         |\n        |  You are using conditional registration via Gems-Realm.  |\n        |  Proceed at your own risk and do not complain if you     |\n        |  CANNOT connect to servers                               |\n        |                                                          |\n        ============================================================\n");
        }
    }
}

