/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.modules.create;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.decoration.MetalScaffoldingBlockItem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.misc.UtilityRecipe;
import net.mehvahdjukaar.every_compat.misc.UtilityTag;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.GemsRealmEntrySet;
import net.xelbayria.gems_realm.api.GemsRealmModule;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.VanillaMetalTypes;

public abstract class CreateAbstractModule
extends GemsRealmModule {
    public final ItemOnlyEntrySet<MetalType, Item> sheet;
    public final SimpleEntrySet<MetalType, Block> casing;
    public final SimpleEntrySet<MetalType, Block> door;
    public final SimpleEntrySet<MetalType, Block> ladder;
    public final SimpleEntrySet<MetalType, Block> scaffolding;
    public final SimpleEntrySet<MetalType, Block> shingles;
    public final SimpleEntrySet<MetalType, Block> shingle_slab;
    public final SimpleEntrySet<MetalType, Block> shingle_stairs;
    public final SimpleEntrySet<MetalType, Block> tiles;
    public final SimpleEntrySet<MetalType, Block> tile_slab;
    public final SimpleEntrySet<MetalType, Block> tile_stairs;
    public final SimpleEntrySet<MetalType, Block> orante_window;
    public final SimpleEntrySet<MetalType, Block> ornate_window_pane;

    public CreateAbstractModule(String modId) {
        super(modId, "c");
        ResourceLocation tab = this.modRes("base");
        ResourceLocation paletteTab = this.modRes("palettes");
        this.sheet = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(MetalType.class, (String)"sheet", (Supplier)this.getModItem("iron_sheet"), () -> VanillaMetalTypes.IRON, metalType -> new Item(new Item.Properties())).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("item/iron_sheet"))).addTag(new ResourceLocation("forge:plates"), Registries.f_256913_)).setTabKey(tab)).build();
        this.addEntry((EntrySet)this.sheet);
        this.casing = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "casing", this.getModBlock("copper_casing"), () -> VanillaMetalTypes.COPPER, this::makeCasingBlock).requiresChildren(new String[]{"ingot"})).addTextureM(this.modRes("block/copper_casing"), GemsRealm.res("block/c/copper_casing_m"))).addTextureM(this.modRes("block/copper_casing_connected"), GemsRealm.res("block/c/copper_casing_connected_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("casing"), Registries.f_256747_)).addTag(this.modRes("casing"), Registries.f_256913_)).setTabKey(tab)).build();
        this.addEntry((EntrySet)this.casing);
        this.door = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "door", this.getModBlock("copper_door"), () -> VanillaMetalTypes.COPPER, this::makeSlidingDoorBlock).requiresFromMap(this.casing.blocks)).addTile(this.getModTile("sliding_door")).setRenderType(RenderLayer.CUTOUT_MIPPED).generateBlockModels(true, new ResourceLocation[]{this.modRes("block/copper_door/fold_left"), this.modRes("block/copper_door/fold_right")}).addTextureM(this.modRes("block/copper_door_bottom"), GemsRealm.res("block/c/copper_door_bottom_m"))).addTextureM(this.modRes("block/copper_door_side"), GemsRealm.res("block/c/copper_door_side_m"))).addTextureM(this.modRes("block/copper_door_top"), GemsRealm.res("block/c/copper_door_top_m"))).addTextureM(this.modRes("item/copper_door"), GemsRealm.res("item/c/copper_door_m"))).addTag(BlockTags.f_144282_, Registries.f_256747_)).setTabKey(tab)).addRecipe(this.modRes("crafting/kinetics/copper_door"))).copyParentDrop().build();
        this.addEntry((EntrySet)this.door);
        this.ladder = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "ladder", this.getModBlock("copper_ladder"), () -> VanillaMetalTypes.COPPER, this::makeMetalLadderBlock).requiresChildren(new String[]{"ingot"})).setRenderType(RenderLayer.CUTOUT_MIPPED).addTexture(this.modRes("block/ladder_copper"))).addTexture(this.modRes("block/ladder_copper_hoop"))).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_13082_, Registries.f_256747_)).addTag(BlockTags.f_201924_, Registries.f_256747_)).addTag(this.modRes("copycat_deny"), Registries.f_256747_)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.ladder);
        this.scaffolding = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "scaffolding", this.getModBlock("copper_scaffolding"), () -> VanillaMetalTypes.COPPER, this::makeMetalScaffoldingBlock).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("block/scaffold/copper_scaffold"))).addTexture(this.modRes("block/scaffold/copper_scaffold_connected"))).addTexture(this.modRes("block/scaffold/copper_scaffold_inside"))).addTexture(this.modRes("block/scaffold/copper_scaffold_inside_connected"))).addTexture(this.modRes("block/funnel/copper_funnel_frame"))).addTag(BlockTags.f_144282_, Registries.f_256747_)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).addCustomItem((metalType, block, properties) -> new MetalScaffoldingBlockItem(block, properties)).build();
        this.addEntry((EntrySet)this.scaffolding);
        this.shingles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "shingles", this.getModBlock("copper_shingles"), () -> VanillaMetalTypes.COPPER, metalType -> new Block(Utils.copyPropertySafe((Block)metalType.block))).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("block/copper/copper_shingles"))).addTexture(this.modRes("block/copper/copper_shingles_top_connected"))).addTexture(this.modRes("block/copper/copper_roof_top"))).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144286_, Registries.f_256747_)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.shingles);
        this.shingle_slab = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "shingle_slab", this.getModBlock("copper_shingle_slab"), () -> VanillaMetalTypes.COPPER, metalType -> new SlabBlock(Utils.copyPropertySafe((Block)metalType.block))).requiresFromMap(this.shingles.blocks)).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144286_, Registries.f_256747_)).addTag(BlockTags.f_13031_, Registries.f_256747_)).addTag(ItemTags.f_13139_, Registries.f_256913_)).setTabKey(tab)).defaultRecipe().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.shingle_slab);
        this.shingle_stairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "shingle_stairs", this.getModBlock("copper_shingle_stairs"), () -> VanillaMetalTypes.COPPER, metalType -> new StairBlock(metalType.block.m_49966_(), Utils.copyPropertySafe((Block)metalType.block))).requiresFromMap(this.shingles.blocks)).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144286_, Registries.f_256747_)).addTag(BlockTags.f_13030_, Registries.f_256747_)).addTag(ItemTags.f_13138_, Registries.f_256913_)).setTabKey(tab)).defaultRecipe().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.shingle_stairs);
        this.tiles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "tiles", this.getModBlock("copper_tiles"), () -> VanillaMetalTypes.COPPER, metalType -> new Block(Utils.copyPropertySafe((Block)metalType.block))).requiresChildren(new String[]{"ingot"})).addTexture(this.modRes("block/copper/copper_tiles"))).addTexture(this.modRes("block/copper/copper_tiles_top_connected"))).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144286_, Registries.f_256747_)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.tiles);
        this.tile_slab = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "tile_slab", this.getModBlock("copper_tile_slab"), () -> VanillaMetalTypes.COPPER, metalType -> new SlabBlock(Utils.copyPropertySafe((Block)metalType.block))).requiresFromMap(this.tiles.blocks)).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144286_, Registries.f_256747_)).addTag(BlockTags.f_13031_, Registries.f_256747_)).addTag(ItemTags.f_13139_, Registries.f_256913_)).setTabKey(tab)).defaultRecipe().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.tile_slab);
        this.tile_stairs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "tile_stairs", this.getModBlock("copper_tile_stairs"), () -> VanillaMetalTypes.COPPER, metalType -> new StairBlock(metalType.block.m_49966_(), Utils.copyPropertySafe((Block)metalType.block))).requiresFromMap(this.tiles.blocks)).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144286_, Registries.f_256747_)).addTag(BlockTags.f_13030_, Registries.f_256747_)).addTag(ItemTags.f_13138_, Registries.f_256913_)).setTabKey(tab)).defaultRecipe().addRecipe(this.modRes("copper_tile_stairs_from_copper_tiles_stonecutting"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry((EntrySet)this.tile_stairs);
        this.orante_window = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "window", "ornate", this.getModBlock("ornate_iron_window"), () -> VanillaMetalTypes.IRON, this::makeWindow).addTextureM(this.modRes("block/palettes/ornate_iron_window"), GemsRealm.res("block/c/ornate_iron_window_m"))).addTexture(this.modRes("block/palettes/ornate_iron_window_end"))).addTextureM(this.modRes("block/palettes/ornate_iron_window_connected"), GemsRealm.res("block/c/ornate_iron_window_connected_m"))).setTabKey(paletteTab)).defaultRecipe().setRenderType(RenderLayer.TRANSLUCENT).build();
        this.addEntry((EntrySet)this.orante_window);
        this.ornate_window_pane = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "window_pane", "ornate", this.getModBlock("ornate_iron_window_pane"), () -> VanillaMetalTypes.IRON, this::makeConnectedGlassPaneBlock).requiresFromMap(this.orante_window.blocks)).addTexture(this.modRes("block/palettes/ornate_iron_window_pane_top"))).addTag(BlockTags.f_13049_, Registries.f_256747_)).addTag(new ResourceLocation("forge:glass_panes"), Registries.f_256747_)).addTag(new ResourceLocation("forge:glass_panes"), Registries.f_256913_)).setTabKey(paletteTab)).defaultRecipe().setRenderType(RenderLayer.TRANSLUCENT).copyParentDrop().build();
        this.addEntry((EntrySet)this.ornate_window_pane);
    }

    protected abstract Block makeCasingBlock(MetalType var1);

    protected abstract Block makeSlidingDoorBlock(MetalType var1);

    protected abstract Block makeMetalLadderBlock(MetalType var1);

    protected abstract Block makeMetalScaffoldingBlock(MetalType var1);

    protected abstract Block makeWindow(MetalType var1);

    protected abstract Block makeConnectedGlassPaneBlock(MetalType var1);

    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            String tilesRecipePath;
            String shinglesRecipePath;
            String scaffoldingRecipePath;
            String ladderRecipePath;
            if (PlatHelper.getPlatform().isFabric()) {
                ladderRecipePath = "copper_ladder_from_copper_ingots_stonecutting";
                scaffoldingRecipePath = "copper_scaffolding_from_copper_ingots_stonecutting";
                shinglesRecipePath = "copper_shingles_from_copper_ingots_stonecutting";
                tilesRecipePath = "copper_tiles_from_copper_ingots_stonecutting";
            } else {
                ladderRecipePath = "copper_ladder_from_ingots_copper_stonecutting";
                scaffoldingRecipePath = "copper_scaffolding_from_ingots_copper_stonecutting";
                shinglesRecipePath = "copper_shingles_from_ingots_copper_stonecutting";
                tilesRecipePath = "copper_tiles_from_ingots_copper_stonecutting";
            }
            this.ladder.blocks.forEach((metalType, block) -> {
                ResourceLocation ladderRecipeId = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "ladder_from_ingots"));
                ResourceLocation scaffoldingRecipeId = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "scaffolding_from_ingots"));
                ResourceLocation shinglesRecipeId = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "shingles_from_ingots"));
                ResourceLocation tilesRecipeId = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "tiles_from_ingots"));
                this.grabTagAndCreateRecipe(ladderRecipePath, ladderRecipeId, "copper", this.ladder.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(scaffoldingRecipePath, scaffoldingRecipeId, "copper", this.scaffolding.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(shinglesRecipePath, shinglesRecipeId, "copper", this.shingles.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(tilesRecipePath, tilesRecipeId, "copper", this.tiles.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
            });
            String pathLog = "item_application/copper_casing_from_log";
            String pathWood = "item_application/copper_casing_from_wood";
            this.casing.blocks.forEach((metalType, block) -> {
                ResourceLocation newResLocLog = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "item_application/", "casing_from_log"));
                ResourceLocation newResLocWood = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "item_application/", "casing_from_wood"));
                this.grabTagAndCreateRecipe(pathLog, newResLocLog, "copper", block, (MetalType)((Object)((Object)metalType)), manager, sink);
                this.grabTagAndCreateRecipe(pathWood, newResLocWood, "copper", block, (MetalType)((Object)((Object)metalType)), manager, sink);
            });
            String pathIngot = "pressing/iron_ingot";
            this.sheet.items.forEach((metalType, item) -> {
                ResourceLocation newResLocIngot = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "pressing/", "ingot"));
                this.grabTagAndCreateRecipe(pathIngot, newResLocIngot, "iron", item, (MetalType)((Object)((Object)metalType)), manager, sink);
            });
        });
    }

    public void grabTagAndCreateRecipe(String recipeLoc, ResourceLocation newRecipeLoc, String oldTypeName, Object newResult, MetalType metalType, ResourceManager manager, ResourceSink sink) {
        String typeName = this.typeName(metalType);
        Pair newTagIngredient = UtilityTag.getATagId((String)this.platformTag(typeName), (String)this.platformTag(typeName.replace("_", "")), (ResourceManager)manager);
        if (((Boolean)newTagIngredient.getSecond()).booleanValue()) {
            UtilityRecipe.createRecipeWithTag((ResourceLocation)this.modRes(recipeLoc), (ResourceLocation)newRecipeLoc, (String)this.platformTag(oldTypeName), (String)((ResourceLocation)newTagIngredient.getFirst()).toString(), (Object)newResult, (ResourceSink)sink, (ResourceManager)manager);
        } else {
            ResourceLocation newTag = GemsRealm.res("ingots/" + metalType.getTypeName());
            boolean isTagCreated = UtilityTag.createAndAddCustomTags((ResourceLocation)newTag, (ResourceSink)sink, (Item[])new Item[]{metalType.getItemOfThis("ingot")});
            UtilityRecipe.createRecipeWithTag((ResourceLocation)this.modRes(recipeLoc), (ResourceLocation)newRecipeLoc, (String)this.platformTag(oldTypeName), (String)newTag.toString(), (Object)newResult, (ResourceSink)sink, (ResourceManager)manager);
            if (!isTagCreated) {
                GemsRealm.LOGGER.error("Failed to create a tag for {} in {}", (Object)newTag.toString(), (Object)Utils.getID((Object)newResult));
            }
        }
    }

    public String typeName(MetalType metalType) {
        return switch (metalType.getId().toString()) {
            case "crystalcraft_unlimited_java:adamantite" -> "adamantium";
            case "crystalcraft_unlimited_java:silicium" -> "silicon";
            case "crystalcraft_unlimited_java:pottasium" -> "potassium";
            case "crystalcraft_unlimited_java:hydro_pottasium" -> "hydratedpotassium";
            case "crystalcraft_unlimited_java:unoptanium" -> "unobtanium";
            case "ms:refined_quartz" -> "quartz";
            default -> metalType.getTypeName();
        };
    }

    public String platformTag(String nameMetal) {
        return PlatHelper.getPlatform().isFabric() ? "c:" + nameMetal + "_ingots" : "forge:ingots/" + nameMetal;
    }
}

