/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.modules.forge.create;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.decoration.MetalScaffoldingCTBehaviour;
import com.simibubi.create.content.decoration.RoofBlockCTBehaviour;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xelbayria.gems_realm.api.GemsRealmModule;
import net.xelbayria.gems_realm.api.set.metal.MetalType;

@OnlyIn(value=Dist.CLIENT)
public class CreateClientModule {
    public static void registerWindowCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, Block> window, SimpleEntrySet<MetalType, Block> window_pane) {
        window.blocks.forEach((metalType, block) -> {
            String blockTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "palettes/ornate_", "window");
            CTSpriteShiftEntry spriteShift = CreateClientModule.vertical(blockTexture, blockTexture + "_connected");
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((Block)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new HorizontalCTBehaviour(spriteShift)));
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((Block)((Block)window_pane.blocks.get(metalType))), model -> new CTModel(model, (ConnectedTextureBehaviour)new GlassPaneCTBehaviour(spriteShift)));
        });
    }

    public static void registerCasingCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, Block> casing) {
        casing.blocks.forEach((metalType, block) -> {
            String blockTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing");
            String connectedTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing_connected");
            CTSpriteShiftEntry spriteShift = CreateClientModule.omni(blockTexture, connectedTexture);
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((Block)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new SimpleCTBehaviour(spriteShift)));
        });
    }

    public static void registerScaffoldCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, Block> scaffold) {
        scaffold.blocks.forEach((metalType, block) -> {
            String scaffoldTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold");
            String insideTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold_inside");
            String scaffoldCTM = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold_connected");
            String insideCTM = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "scaffold/", "scaffold_inside_connected");
            String casingTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing");
            String casingCTM = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), "", "casing_connected");
            CTSpriteShiftEntry scaffoldShift = CreateClientModule.horizontal(scaffoldTexture, scaffoldCTM);
            CTSpriteShiftEntry scaffoldInsideShift = CreateClientModule.horizontal(insideTexture, insideCTM);
            CTSpriteShiftEntry casingShift = CreateClientModule.omni(casingTexture, casingCTM);
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((Block)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new MetalScaffoldingCTBehaviour(scaffoldShift, scaffoldInsideShift, casingShift)));
        });
    }

    public static void registerShinglesCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, Block> shingles) {
        shingles.blocks.forEach((metalType, block) -> {
            String topTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), metalType.getTypeName() + "/", "roof_top");
            String topConnectedTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), metalType.getTypeName() + "/", "shingles_top_connected");
            CTSpriteShiftEntry roofShift = CTSpriteShifter.getCT((CTType)AllCTTypes.ROOF, (ResourceLocation)new ResourceLocation(topTexture), (ResourceLocation)new ResourceLocation(topConnectedTexture));
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((Block)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new RoofBlockCTBehaviour(roofShift)));
        });
    }

    public static void registerTilesCTBehavior(GemsRealmModule module, SimpleEntrySet<MetalType, Block> tiles) {
        tiles.blocks.forEach((metalType, block) -> {
            String topTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), metalType.getTypeName() + "/", "roof_top");
            String topConnectedTexture = metalType.createFullIdWith("gemsrealm", "block", module.shortenedId(), metalType.getTypeName() + "/", "tiles_top_connected");
            CTSpriteShiftEntry roofShift = CTSpriteShifter.getCT((CTType)AllCTTypes.ROOF, (ResourceLocation)new ResourceLocation(topTexture), (ResourceLocation)new ResourceLocation(topConnectedTexture));
            CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID((Block)block), model -> new CTModel(model, (ConnectedTextureBehaviour)new RoofBlockCTBehaviour(roofShift)));
        });
    }

    private static CTSpriteShiftEntry omni(String blockTexture, String connectedTexture) {
        return CTSpriteShifter.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, (ResourceLocation)new ResourceLocation(blockTexture), (ResourceLocation)new ResourceLocation(connectedTexture));
    }

    private static CTSpriteShiftEntry horizontal(String blockTexture, String connectedTexture) {
        return CTSpriteShifter.getCT((CTType)AllCTTypes.HORIZONTAL, (ResourceLocation)new ResourceLocation(blockTexture), (ResourceLocation)new ResourceLocation(connectedTexture));
    }

    private static CTSpriteShiftEntry vertical(String blockTexture, String connectedTexture) {
        return CTSpriteShifter.getCT((CTType)AllCTTypes.VERTICAL, (ResourceLocation)new ResourceLocation(blockTexture), (ResourceLocation)new ResourceLocation(connectedTexture));
    }
}

