/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.modules.forge.create;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.decoration.MetalLadderBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingBlock;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorRenderer;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlock;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockItem;
import com.simibubi.create.content.logistics.tableCloth.TableClothRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Couple;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.GemsRealmEntrySet;
import net.xelbayria.gems_realm.api.GemsRealmModule;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.VanillaMetalTypes;
import net.xelbayria.gems_realm.modules.create.CreateAbstractModule;
import net.xelbayria.gems_realm.modules.forge.create.CreateClientModule;

public class CreateModule
extends CreateAbstractModule {
    public final SimpleEntrySet<MetalType, Block> table_cloth;

    public CreateModule(String modId) {
        super(modId);
        ResourceLocation tab = this.modRes("base");
        ResourceLocation paletteTab = this.modRes("palettes");
        this.table_cloth = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)GemsRealmEntrySet.of(MetalType.class, "table_cloth", this.getModBlock("copper_table_cloth"), () -> VanillaMetalTypes.COPPER, metalType -> new TableClothBlock(Utils.copyPropertySafe((Block)metalType.block), metalType.getTypeName())).addTile(this.getModTile("table_cloth")).requiresChildren(new String[]{"ingot"})).addTextureM(this.modRes("block/table_cloth/copper"), GemsRealm.res("block/c/copper_table_cloth_m"))).addTag(BlockTags.f_144282_, Registries.f_256747_)).addTag(BlockTags.f_144271_, Registries.f_256747_)).addTag(this.modRes("table_cloths"), Registries.f_256747_)).addTag(this.modRes("table_cloths"), Registries.f_256913_)).setTabKey(tab)).setRenderType(RenderLayer.CUTOUT_MIPPED).addCustomItem((metalType, block, properties) -> new TableClothBlockItem(block, properties)).build();
        this.addEntry((EntrySet)this.table_cloth);
    }

    @Override
    protected Block makeCasingBlock(MetalType metalType) {
        return new CasingBlock(Utils.copyPropertySafe((Block)metalType.block).m_60918_(metalType.getSound()));
    }

    @Override
    protected Block makeSlidingDoorBlock(MetalType metalType) {
        return SlidingDoorBlock.metal((BlockBehaviour.Properties)Utils.copyPropertySafe((Block)metalType.block).m_60918_(metalType.getSound()).m_60955_(), (boolean)true);
    }

    @Override
    protected Block makeMetalLadderBlock(MetalType metalType) {
        return new MetalLadderBlock(Utils.copyPropertySafe((Block)metalType.block));
    }

    @Override
    protected Block makeMetalScaffoldingBlock(MetalType metalType) {
        return new MetalScaffoldingBlock(Utils.copyPropertySafe((Block)metalType.block));
    }

    protected WindowBlock makeWindow(MetalType metalType) {
        return new WindowBlock(Utils.copyPropertySafe((Block)Blocks.f_50058_).m_60922_((s, l, ps, t) -> false).m_60924_((s, l, ps) -> false).m_60960_((s, l, ps) -> false).m_60971_((s, l, ps) -> false), false);
    }

    @Override
    protected Block makeConnectedGlassPaneBlock(MetalType metalType) {
        return new ConnectedGlassPaneBlock(Utils.copyPropertySafe((Block)Blocks.f_50185_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        event.register(this.table_cloth.getTile(TableClothBlockEntity.class), TableClothRenderer::new);
        event.register(this.door.getTile(SlidingDoorBlockEntity.class), SlidingDoorRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientSetup() {
        super.onClientSetup();
        CreateClientModule.registerCasingCTBehavior(this, (SimpleEntrySet<MetalType, Block>)this.casing);
        CreateClientModule.registerScaffoldCTBehavior(this, (SimpleEntrySet<MetalType, Block>)this.scaffolding);
        CreateClientModule.registerWindowCTBehavior(this, (SimpleEntrySet<MetalType, Block>)this.orante_window, (SimpleEntrySet<MetalType, Block>)this.ornate_window_pane);
    }

    public void onModSetup() {
        super.onModSetup();
        CreateModule.putFoldingDoor(this, (SimpleEntrySet<MetalType, Block>)this.door);
    }

    private static void putFoldingDoor(GemsRealmModule module, SimpleEntrySet<MetalType, Block> doors) {
        doors.blocks.forEach((metalType, block) -> {
            String path = metalType.createPathWith(module.shortenedId(), "door");
            AllPartialModels.FOLDING_DOORS.put(GemsRealm.res(path), Couple.create((Object)CreateModule.block(path + "/fold_left"), (Object)CreateModule.block(path + "/fold_right")));
        });
    }

    private static PartialModel block(String path) {
        return PartialModel.of((ResourceLocation)GemsRealm.res("block/" + path));
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            String table_clothRecipePath = "copper_table_cloth_from_ingots_copper_stonecutting";
            this.ladder.blocks.forEach((metalType, block) -> {
                ResourceLocation table_clothRecipeId = new ResourceLocation(metalType.createFullIdWith("gemsrealm", "", this.shortenedId(), "stonecutting/", "_table_cloth_from_ingots"));
                this.grabTagAndCreateRecipe(table_clothRecipePath, table_clothRecipeId, "copper", this.table_cloth.blocks.get(metalType), (MetalType)((Object)((Object)metalType)), manager, sink);
            });
        });
    }
}

