/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.rftools;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.rftools.RFTUtils;
import mcjty.rftools.blocks.storage.GuiModularStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GuiModularStorage.class}, remap=false)
public abstract class MixinGuiModularStorage {
    @Unique
    private boolean mte_patches$isShiftClickedItem = false;

    @Inject(method={"mouseClicked(III)V"}, at={@At(value="RETURN")}, remap=true)
    public void onMouseDown(int x, int y, int button, CallbackInfo ci) {
        GuiModularStorage guiModularStorage = (GuiModularStorage)this;
        if (!MTEPatchesConfig.rftools.storageGuiShiftTweak) {
            return;
        }
        if (!guiModularStorage.field_146994_N.func_190926_b() && RFTUtils.isSlotInStorageGUI(guiModularStorage.field_146998_K)) {
            this.mte_patches$isShiftClickedItem = true;
        }
    }

    @Inject(method={"mouseReleased(III)V"}, at={@At(value="RETURN")}, remap=true)
    public void onMouseUp(int x, int y, int state, CallbackInfo ci) {
        if (!MTEPatchesConfig.rftools.storageGuiShiftTweak) {
            return;
        }
        this.mte_patches$isShiftClickedItem = false;
    }

    @Inject(method={"updateList()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void preventUpdate(CallbackInfo ci) {
        if (!MTEPatchesConfig.rftools.storageGuiShiftTweak) {
            return;
        }
        if (this.mte_patches$isShiftClickedItem) {
            ci.cancel();
        }
    }

    @Shadow
    protected abstract Slot findEmptySlot();

    @Inject(method={"getSlotAtPosition(II)Lnet/minecraft/inventory/Slot;"}, at={@At(value="RETURN")}, remap=true, cancellable=true)
    public void insertToEmptySlot(int x, int y, CallbackInfoReturnable<Slot> cir) {
        if (!MTEPatchesConfig.rftools.storageGuiInsertTweak) {
            return;
        }
        ItemStack heldStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        Slot hoveredSlot = (Slot)cir.getReturnValue();
        if (heldStack.func_190926_b() || !RFTUtils.isSlotInStorageGUI(hoveredSlot)) {
            return;
        }
        ItemStack hoveredStack = hoveredSlot.func_75211_c();
        if (!(GuiScreen.func_146272_n() || Container.func_94527_a((Slot)hoveredSlot, (ItemStack)heldStack, (boolean)true) && hoveredStack.func_190916_E() < hoveredStack.func_77976_d())) {
            cir.setReturnValue((Object)this.findEmptySlot());
        }
    }
}

