/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.railcraft;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.MTEPatchesMod;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AdjacentTileCache.class}, remap=false)
public abstract class MixinAdjacentTileCache {
    @Shadow
    @Final
    private TileEntity source;
    @Unique
    int mtepatches_last_world_time = 0;

    @Shadow
    public abstract void purge();

    @Inject(method={"refresh()V"}, at={@At(value="HEAD")})
    public void forcePurgeAfterInterval(CallbackInfo ci) {
        if (MTEPatchesConfig.railcraft.tileCachePurgeInterval == 0) {
            return;
        }
        if (this.source.func_145831_w().field_72995_K) {
            return;
        }
        MinecraftServer server = this.source.func_145831_w().func_73046_m();
        if (server == null) {
            return;
        }
        int newTime = server.func_71259_af();
        if (newTime > this.mtepatches_last_world_time && newTime - this.mtepatches_last_world_time <= MTEPatchesConfig.railcraft.tileCachePurgeInterval) {
            return;
        }
        this.mtepatches_last_world_time = newTime;
        this.purge();
        MTEPatchesMod.logDebug("Purging tile at {}", this.source.func_174877_v());
    }
}

