/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.render;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.MTEPatchesMod;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class RenderSkipRegistry {
    public static final RenderSkipRegistry INSTANCE = new RenderSkipRegistry();
    public final Set<Class<?>> skipFar = new HashSet();
    public final Set<Class<?>> skipFarTiles = new HashSet();
    public final Set<Class<?>> skipShadows = new HashSet();
    public final Set<Class<?>> skipShadowsTiles = new HashSet();

    public void reloadConfigs() {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        this.skipFar.clear();
        this.skipShadows.clear();
        RenderSkipRegistry.parseClassToConfigs(MTEPatchesConfig.render.farCulling.extra_tesrs, this.skipFar, this.skipFarTiles, "farCulling_custom");
        RenderSkipRegistry.parseClassToConfigs(MTEPatchesConfig.render.shadowCulling.extra_tesrs, this.skipShadows, this.skipShadowsTiles, "shadowCulling_custom");
    }

    private static void parseClassToConfigs(String[] configLines, Set<Class<?>> tesrClasses, Set<Class<?>> teClasses, String sectionName) {
        for (String s : configLines) {
            try {
                String trim = s.split("#")[0].trim();
                if (trim.isEmpty()) continue;
                Class<?> aClass = Class.forName(trim);
                if (TileEntitySpecialRenderer.class.isAssignableFrom(aClass)) {
                    tesrClasses.add(aClass);
                    continue;
                }
                if (TileEntity.class.isAssignableFrom(aClass)) {
                    teClasses.add(aClass);
                    continue;
                }
                MTEPatchesMod.getLogger().warn("Class {} in {} is neither a TileEntity or a TileEntitySpecialRenderer, skipping it", (Object)s, (Object)sectionName);
            }
            catch (Throwable e) {
                MTEPatchesMod.getLogger().warn("Error loading {}: config line \"{}\" : ", (Object)sectionName, (Object)s, (Object)e);
            }
        }
    }
}

