/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches;

import net.minecraftforge.common.config.Config;

@Config(modid="mtepatches", type=Config.Type.INSTANCE, category="general")
public class MTEPatchesConfig {
    @Config.LangKey(value="config.mtepatches.vanilla.name")
    public static CategoryVanilla vanilla = new CategoryVanilla();
    @Config.LangKey(value="config.mtepatches.railcraft.name")
    public static CategoryRailcraft railcraft = new CategoryRailcraft();
    @Config.LangKey(value="config.mtepatches.ic2.name")
    public static CategoryIC2 ic2 = new CategoryIC2();
    @Config.LangKey(value="config.mtepatches.thermal.name")
    public static CategoryThermal thermal = new CategoryThermal();
    @Config.LangKey(value="config.mtepatches.forestry.name")
    public static CategoryForestry forestry = new CategoryForestry();
    @Config.LangKey(value="config.mtepatches.rftools.name")
    public static CategoryRFTools rftools = new CategoryRFTools();
    @Config.LangKey(value="config.mtepatches.buildcraft.name")
    public static CategoryBC buildcraft = new CategoryBC();
    @Config.LangKey(value="config.mtepatches.moarTinkers.name")
    public static CategoryMoarTinkers moarTinkers = new CategoryMoarTinkers();
    @Config.LangKey(value="config.mtepatches.industrialforegoing.name")
    public static CategoryIF industrialforegoing = new CategoryIF();
    public static CategoryConnectionTimeout connectionTimeout = new CategoryConnectionTimeout();
    @Config.LangKey(value="config.mtepatches.projectred.name")
    public static CategoryProjectRed projectred = new CategoryProjectRed();
    @Config.LangKey(value="config.mtepatches.storageDrawers.name")
    public static CategoryStorageDrawers storageDrawers = new CategoryStorageDrawers();
    @Config.LangKey(value="config.mtepatches.bop.name")
    public static CategoryBOP bop = new CategoryBOP();
    @Config.LangKey(value="config.mtepatches.steveCarts.name")
    public static CategorySteveCarts steveCarts = new CategorySteveCarts();
    @Config.Comment(value={"Enable debug output for some patches. May cause log spamming!"})
    public static boolean debugOutput = false;

    public static class CategorySteveCarts {
        @Config.Comment(value={"Allow using any opaque, solid, non-falling block in bridger."})
        @Config.LangKey(value="config.mtepatches.steveCarts.moreBridgingBlocks.name")
        public boolean moreBridgingBlocks = true;
    }

    public static class CategoryBOP {
        @Config.Comment(value={"The range for BOP to check fog. BOP Default is 20. Reduce for better performance but worse custom fog quality."})
        @Config.LangKey(value="config.mtepatches.bop.fogCheckRange.name")
        public int fogCheckRange = 5;
        @Config.Comment(value={"Disables BOP custom fog completely."})
        @Config.LangKey(value="config.mtepatches.bop.disableFog.name")
        public boolean disableFog = false;
    }

    public static class CategoryStorageDrawers {
        @Config.Comment(value={"QoL feature: Unmark an slot from an formerly-locked drawer with a left-click."})
        @Config.LangKey(value="config.mtepatches.storageDrawers.clearEmptySlot.name")
        public boolean clearEmptySlot = true;
    }

    public static class CategoryProjectRed {
        @Config.Comment(value={"Fix mining speed for machines and parts on ProjectRed"})
        @Config.LangKey(value="config.mtepatches.projectred.fixMiningSpeed.name")
        public boolean fixMiningSpeed = true;
        @Config.Comment(value={"Fix inventory size for certain machines to fix crashes"})
        @Config.LangKey(value="config.mtepatches.projectred.fixMachineInventorySizes.name")
        public boolean fixMachineInventorySizes = true;
        @Config.Comment(value={"Prevent overflow items cramming in pressure tubes.", "Pressure tubes with stacks more than this value will be considered unpassable when pathfinding, so items won't cram up infinitely and cause huge lags.", "Set to 0 to disable this feature."})
        @Config.LangKey(value="config.mtepatches.projectred.pressureTubeOverflowLimit.name")
        public int pressureTubeOverflowLimit = 64;
    }

    public static class CategoryConnectionTimeout {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Add a timeout when it's retrieving info for some mods, prevent it from sticking the loading progress forever on a lossy internet connection.", "Set to 0 for infinite timeout."})
        @Config.LangKey(value="config.mtepatches.connectionTimeout.timeout.name")
        @Config.RangeInt(min=0)
        public int timeout = 5000;
        @Config.Comment(value={"Enable timeout for Biomes o' Plenty when it's checking trail info."})
        public boolean bop = true;
        @Config.Comment(value={"Enable timeout for Industrial Foregoing when it's checking contributors."})
        public boolean industrialForegoing = true;
    }

    public static class CategoryIF {
        @Config.Comment(value={"Fixes a item duplication bug for the insertion conveyor upgrade"})
        @Config.LangKey(value="config.mtepatches.industrialforegoing.fixConveyorInsertionDuplication.name")
        public boolean fixConveyorInsertionDuplication = true;
        @Config.Comment(value={"Do null check before meat feeder drains fluid from containers. Prevents potential NullPointerException."})
        @Config.LangKey(value="config.mtepatches.industrialforegoing.fixMeatFeederTickNull.name")
        public boolean fixMeatFeederTickNull = true;
    }

    public static class CategoryMoarTinkers {
        @Config.Comment(value={"Disables server-side mining speed boost of traits when sneaking"})
        @Config.LangKey(value="config.mtepatches.moarTinkers.sneakDisablesMiningBoost.name")
        public boolean sneakDisablesMiningBoost = true;
    }

    public static class CategoryBC {
        @Config.Comment(value={"Allows BuildCraft item pipes to accept items ejected from hoppers and machines from other mods"})
        @Config.LangKey(value="config.mtepatches.buildcraft.itemPipeAcceptEjection.name")
        @Config.RequiresWorldRestart
        public boolean itemPipeAcceptEjection = true;
        @Config.Comment(value={"Make BuildCraft compatible with Forge Energy and Redstone Flux."})
        @Config.LangKey(value="config.mtepatches.buildcraft.mjToForgeEnergy.name")
        @Config.RequiresWorldRestart
        public boolean mjToForgeEnergy = false;
        @Config.Comment(value={"Conversion ratio from MJ to FE. Should not be zero."})
        @Config.LangKey(value="config.mtepatches.buildcraft.mjToForgeEnergyRatio.name")
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        public double mjToForgeEnergyRatio = 10.0;
        @Config.Comment(value={"Apply the transfer rate limits to kinesis pipes.", "Also limits how much power can be stored in it."})
        @Config.LangKey(value="config.mtepatches.buildcraft.limitPipePower.name")
        public boolean limitPipePower = false;
        @Config.Comment(value={"Cache adaptor capabilities created by this mod. Only disable this for debug!"})
        @Config.LangKey(value="config.mtepatches.buildcraft.cacheAdaptors.name")
        public boolean cacheAdaptors = true;
    }

    public static class CategoryRFTools {
        @Config.Comment(value={"In modular storage GUI, when pulling items with shift,", "don't refresh the list until mouse is released.", "Improves compatibility with MouseTweaks."})
        @Config.LangKey(value="config.mtepatches.rftools.storageGuiShiftTweak.name")
        public boolean storageGuiShiftTweak = true;
        @Config.Comment(value={"In modular storage GUI, when putting your held item into the storage, prevent swapping the hovered item out from the storage."})
        @Config.LangKey(value="config.mtepatches.rftools.storageGuiInsertTweak.name")
        public boolean storageGuiInsertTweak = true;
    }

    public static class CategoryForestry {
        @Config.Comment(value={"Prevent faulty bee queen without mated tag from crashing the server when put into beekeeping.", "They will be replaced with a princess with the same NBT."})
        @Config.LangKey(value="config.mtepatches.forestry.faultyQueenFix.name")
        public boolean faultyQueenFix = true;
        @Config.Comment(value={"Fix multi-farm does not return dirt or sand when replacing soil."})
        @Config.LangKey(value="config.mtepatches.forestry.multiFarmSoilReplaceFix.name")
        public boolean multiFarmSoilReplaceFix = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Remove Buildcraft version check for the compat modules. Fixes the module not loading with BC 8.0."})
        @Config.LangKey(value="config.mtepatches.forestry.bc8Compat.name")
        public boolean bc8Compat = true;
        @Config.Comment(value={"Fix collision box for bio generator."})
        @Config.LangKey(value="config.mtepatches.forestry.collisionBoxFix.name")
        public boolean collisionBoxFix = true;
    }

    public static class CategoryThermal {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Don't match input NBT for recycling recipes of smelter and sawmill.", "Allows recycling enchanted items with them."})
        @Config.LangKey(value="config.mtepatches.thermal.recycleRecipesFuzzyNBT.name")
        public boolean recycleRecipesFuzzyNBT = true;
    }

    public static class CategoryIC2 {
        @Config.Comment(value={"Make IC2 crop stick able to put on any BlockFarmland, including the ones added by mods."})
        @Config.LangKey(value="config.mtepatches.ic2.cropOnAllFarmlands.name")
        public boolean cropOnAllFarmlands = true;
        @Config.Comment(value={"Prevent breaking crop sticks when walking over it"})
        @Config.LangKey(value="config.mtepatches.ic2.noTrampleCrops.name")
        public boolean noTrampleCrops = true;
        @Config.Comment(value={"Fix mass fabricator stuck permanently after it's output is blocked."})
        @Config.LangKey(value="config.mtepatches.ic2.massFabStuckFix.name")
        public boolean massFabStuckFix = true;
        @Config.Comment(value={"Prevent IC2 keybinds in inventory GUIs.", "Fixes jetpack being activated when pressing jump with the inventory open."})
        @Config.LangKey(value="config.mtepatches.ic2.blockKeybindInGUI.name")
        public boolean blockKeybindInGUI = true;
        @Config.Comment(value={"Fixes a bug that on a LAN server, all IC2 messages are sent to the host, instead of the player that should receive the message."})
        @Config.LangKey(value="config.mtepatches.ic2.lanMessageFix.name")
        public boolean lanMessageFix = true;
        @Config.Comment(value={"Fixes crops detecting additional dirt under farmland."})
        @Config.LangKey(value="config.mtepatches.ic2.cropDirtDetectionFix.name")
        public boolean cropDirtDetectionFix = true;
    }

    public static class CategoryRailcraft {
        @Config.Comment(value={"Fix a desync bug of multiblock that when the multiblock is across chunks. ", "When desync, client can get its inventory scrambled when right-clicking at the bugged multiblock. "})
        @Config.LangKey(value="config.mtepatches.railcraft.multiblockfix.name")
        public boolean multiblockSyncFix = true;
        @Config.Comment(value={"Fix turbine being fixed for free when putting in crafting slot with a blade and take it out."})
        @Config.LangKey(value="config.mtepatches.railcraft.turbineCraftingFix.name")
        public boolean turbineRepairingFix = true;
        @Config.Comment(value={"Fix outfitted tracks drops only the kit but not the track when destroyed."})
        @Config.LangKey(value="config.mtepatches.railcraft.outfittedDropsFix.name")
        public boolean outfittedDropsFix = true;
        @Config.Comment(value={"Allow track relayer to replace outfitted track."})
        @Config.LangKey(value="config.mtepatches.railcraft.replaceOutfittedTrack.name")
        public boolean replaceOutfittedTrack = true;
        @Config.Comment(value={"This fix improves stability of charge network by a lot, but it's still a bit buggy yet.", "Try to place and break cables when ran into problem with charge network."})
        @Config.LangKey(value="config.mtepatches.railcraft.chargeNetworkFix.name")
        public boolean chargeNetworkFix = true;
        @Config.Comment(value={"Show debug particles and message for the charge network fix."})
        @Config.LangKey(value="config.mtepatches.railcraft.chargeNetworkFixDebug.name")
        public boolean chargeNetworkFixDebug = false;
        @Config.Comment(value={"Optimize Item Loader/Unloaders by moving more multiple items at a time, then wait for a cooldown, reducing lag. ", "This option changes the interval to move items. Also affects maximum moved stacksize.", "Set to 0 to disable the optimization."})
        @Config.LangKey(value="config.mtepatches.railcraft.itemMoveInterval.name")
        @Config.RangeInt(min=0)
        public int itemMoveInterval = 16;
        @Config.Comment(value={"Tile caches can miss some updates occuring in neighbouring tileentities, like multiblock formation. ", "This patch adds an interval(in ticks) to purge the cache.", "Even when the interval is reached, the cache only will be purged when it's accessed, like when item unloader unloading items.", "Set to 0 to disable."})
        @Config.LangKey(value="config.mtepatches.railcraft.tileCachePurgeInterval.name")
        @Config.RangeInt(min=0)
        public int tileCachePurgeInterval = 200;
    }

    public static class CategoryVanilla {
        @Config.Comment(value={"Stops receiving new item entities on client when player is dead. Item entities doesn't remove correctly on client-side when player is dead, so they can get more and more over time, causing huge lags."})
        @Config.LangKey(value="config.mtepatches.vanilla.dontReceiveItemsWhenDead.name")
        public boolean dontReceiveItemsWhenDead = true;
    }
}

