/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.buildcraft;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import java.util.EnumMap;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;

public abstract class CachingAdaptorProvider<K, V> {
    protected final HashMap<K, V> adaptors = new HashMap();
    protected final EnumMap<EnumFacing, K> sides = new EnumMap(EnumFacing.class);
    @Nullable
    protected K keyNullFacing;

    protected V getOrCreateAdaptor(K cap, EnumFacing facing) {
        if (!MTEPatchesConfig.buildcraft.cacheAdaptors) {
            return this.createNewAdaptor(cap);
        }
        V adaptor = this.adaptors.get(cap);
        if (adaptor != null) {
            return adaptor;
        }
        adaptor = this.createNewAdaptor(cap);
        this.adaptors.put(cap, adaptor);
        if (facing != null) {
            if (this.sides.containsKey(facing)) {
                this.adaptors.remove(this.sides.get(facing));
            }
            this.sides.put(facing, (EnumFacing)cap);
        } else {
            if (this.keyNullFacing != null) {
                this.adaptors.remove(this.keyNullFacing);
            }
            this.keyNullFacing = cap;
        }
        return adaptor;
    }

    protected abstract V createNewAdaptor(K var1);
}

