/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.buildcraft;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import io.bluebeaker.mtepatches.buildcraft.BCUtils;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyAdaptorMJtoFE
implements IEnergyStorage {
    public final IMjConnector mjConnector;
    public final boolean canReceive;
    public final boolean canRead;
    private long mjRemaining = 0L;

    public EnergyAdaptorMJtoFE(IMjConnector mjConnector) {
        this.mjConnector = mjConnector;
        this.canReceive = mjConnector instanceof IMjReceiver;
        this.canRead = mjConnector instanceof IMjReadable;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.canReceive && ((IMjReceiver)this.mjConnector).canReceive()) {
            IMjReceiver receiver = (IMjReceiver)this.mjConnector;
            long mjReceive = Math.min(this.getMaxInsertMJ(), BCUtils.convertFEtoMJ(maxReceive) + this.mjRemaining);
            long mjTransfered = BCUtils.receiveMJGetTransfered(receiver, mjReceive, simulate);
            int leftFE = BCUtils.convertMJtoFE(mjTransfered);
            this.mjRemaining = mjTransfered - BCUtils.convertFEtoMJ(leftFE);
            return leftFE;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public long getMaxInsertMJ() {
        if (this.mjConnector instanceof IMjReadable) {
            IMjReadable readable = (IMjReadable)this.mjConnector;
            return readable.getCapacity() - readable.getStored();
        }
        return Long.MAX_VALUE;
    }

    public int getEnergyStored() {
        if (this.canRead) {
            return BCUtils.convertMJtoFE(((IMjReadable)this.mjConnector).getStored());
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.canRead) {
            return BCUtils.convertMJtoFE(((IMjReadable)this.mjConnector).getCapacity());
        }
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.canReceive && ((IMjReceiver)this.mjConnector).canReceive();
    }
}

