/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.buildcraft;

import buildcraft.api.inventory.IItemTransactor;
import buildcraft.lib.misc.CapUtil;
import buildcraft.transport.tile.TilePipeHolder;
import io.bluebeaker.mtepatches.buildcraft.CachingAdaptorProvider;
import io.bluebeaker.mtepatches.buildcraft.ItemPipeHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemTransactorAdaptor
extends CachingAdaptorProvider<IItemTransactor, ItemPipeHandler>
implements ICapabilityProvider {
    @Nonnull
    public final TilePipeHolder tile;

    public ItemTransactorAdaptor(@Nonnull TilePipeHolder tile) {
        this.tile = tile;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.shouldAddCapability(capability, facing)) {
            return this.tile.hasCapability(CapUtil.CAP_ITEM_TRANSACTOR, facing);
        }
        return false;
    }

    protected boolean shouldAddCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return facing != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        IItemTransactor transactor;
        if (this.shouldAddCapability(capability, facing) && (transactor = (IItemTransactor)this.tile.getCapability(CapUtil.CAP_ITEM_TRANSACTOR, facing)) != null) {
            return (T)this.getOrCreateAdaptor(transactor, facing);
        }
        return null;
    }

    @Override
    protected ItemPipeHandler createNewAdaptor(IItemTransactor cap) {
        return new ItemPipeHandler(cap);
    }
}

