/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.forestry;

import forestry.core.blocks.BlockBase;
import forestry.energy.blocks.BlockEngine;
import forestry.energy.blocks.BlockTypeEngine;
import forestry.plugins.PluginIC2;
import io.bluebeaker.mtepatches.LoadedModChecker;
import io.bluebeaker.mtepatches.MTEPatchesConfig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEngine.class}, remap=false)
public abstract class MixinBlockEngine
extends BlockBase<BlockTypeEngine> {
    public MixinBlockEngine(BlockTypeEngine blockType) {
        super((Enum)blockType);
    }

    @Inject(method={"addCollisionBoxToList"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void bioGenCollision(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_, CallbackInfo ci) {
        if (!MTEPatchesConfig.forestry.collisionBoxFix || !LoadedModChecker.ic2.isLoaded()) {
            return;
        }
        BlockEngine engine = (BlockEngine)this;
        if (engine == PluginIC2.getBlocks().generator) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos);
            if (entityBox.func_72326_a(axisalignedbb)) {
                collidingBoxes.add(axisalignedbb);
            }
            ci.cancel();
        }
    }

    @Inject(method={"collisionRayTrace"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void bioGenCollisionRay(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end, CallbackInfoReturnable<RayTraceResult> cir) {
        if (!MTEPatchesConfig.forestry.collisionBoxFix || !LoadedModChecker.ic2.isLoaded()) {
            return;
        }
        BlockEngine engine = (BlockEngine)this;
        if (engine == PluginIC2.getBlocks().generator) {
            cir.setReturnValue((Object)super.func_180636_a(blockState, worldIn, pos, start, end));
        }
    }

    @Inject(method={"isOrientedAtEnergyReciever"}, at={@At(value="HEAD")}, cancellable=true)
    private static void dontRotateBioGen(World world, BlockPos pos, EnumFacing orientation, CallbackInfoReturnable<Boolean> cir) {
        if (!MTEPatchesConfig.forestry.collisionBoxFix || !LoadedModChecker.ic2.isLoaded()) {
            return;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == PluginIC2.getBlocks().generator) {
            cir.setReturnValue((Object)false);
        }
    }
}

