/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.railcraft;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.railcraft.InventoryUtils;
import java.util.UUID;
import java.util.function.Predicate;
import mods.railcraft.common.blocks.machine.manipulator.TileItemManipulator;
import mods.railcraft.common.blocks.machine.manipulator.TileManipulatorCart;
import mods.railcraft.common.util.inventory.IInventoryComposite;
import mods.railcraft.common.util.misc.Predicates;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TileItemManipulator.class}, remap=false)
public abstract class MixinTileItemManipulator
extends TileManipulatorCart {
    @Unique
    int mte_patches$cooldown = 0;
    @Unique
    boolean mte_patches$lastProcessing = false;
    @Unique
    UUID mte_patches$lastCartID;

    @Redirect(method={"processCart(Lnet/minecraft/entity/item/EntityMinecart;)V"}, at=@At(value="INVOKE", target="Lmods/railcraft/common/util/inventory/IInventoryComposite;moveOneItemTo(Lmods/railcraft/common/util/inventory/IInventoryComposite;)Lnet/minecraft/item/ItemStack;", ordinal=0))
    public ItemStack redirectMoveOneItem0(IInventoryComposite instance, IInventoryComposite dest) {
        if (MTEPatchesConfig.railcraft.itemMoveInterval == 0) {
            return instance.moveOneItemTo(dest);
        }
        return this.mte_patches$moveItems(instance, dest, Predicates.alwaysTrue());
    }

    @Redirect(method={"processCart(Lnet/minecraft/entity/item/EntityMinecart;)V"}, at=@At(value="INVOKE", target="Lmods/railcraft/common/util/inventory/IInventoryComposite;moveOneItemTo(Lmods/railcraft/common/util/inventory/IInventoryComposite;Ljava/util/function/Predicate;)Lnet/minecraft/item/ItemStack;"))
    public ItemStack redirectMoveOneItem1(IInventoryComposite instance, IInventoryComposite dest, Predicate<ItemStack> filter) {
        if (MTEPatchesConfig.railcraft.itemMoveInterval == 0) {
            return instance.moveOneItemTo(dest, filter);
        }
        return this.mte_patches$moveItems(instance, dest, filter);
    }

    @Redirect(method={"moveItem(Ljava/util/stream/Stream;)V"}, at=@At(value="INVOKE", target="Lmods/railcraft/common/util/inventory/IInventoryComposite;moveOneItemTo(Lmods/railcraft/common/util/inventory/IInventoryComposite;Ljava/util/function/Predicate;)Lnet/minecraft/item/ItemStack;"))
    public ItemStack redirectMoveOneItem2(IInventoryComposite instance, IInventoryComposite dest, Predicate<ItemStack> filter) {
        if (MTEPatchesConfig.railcraft.itemMoveInterval == 0) {
            return instance.moveOneItemTo(dest, filter);
        }
        return this.mte_patches$moveItems(instance, dest, filter);
    }

    @Unique
    private ItemStack mte_patches$moveItems(IInventoryComposite instance, IInventoryComposite dest, Predicate<ItemStack> filter) {
        ItemStack itemStack = InventoryUtils.moveStackInternal(instance, dest, filter);
        this.mte_patches$cooldown = InventoryUtils.getCooldownFromMovedStack(itemStack);
        this.mte_patches$lastProcessing = !itemStack.func_190926_b();
        return itemStack;
    }

    @Inject(method={"processCart(Lnet/minecraft/entity/item/EntityMinecart;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void transferCooldown(EntityMinecart cart, CallbackInfo ci) {
        if (MTEPatchesConfig.railcraft.itemMoveInterval == 0) {
            return;
        }
        UUID cartID = cart.func_110124_au();
        if (cartID != this.mte_patches$lastCartID) {
            this.mte_patches$lastCartID = cartID;
            this.mte_patches$cooldown = 0;
        }
        if (this.mte_patches$cooldown > 0) {
            --this.mte_patches$cooldown;
            this.setProcessing(this.mte_patches$lastProcessing);
            ci.cancel();
        }
    }

    @Intrinsic
    protected void onNoCart() {
        this.mte_patches$cooldown = 0;
    }
}

