/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.buildcraft;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import io.bluebeaker.mtepatches.buildcraft.BCUtils;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EnergyAdaptorFEtoMJ
implements IMjReceiver,
IMjReadable,
IMjPassiveProvider {
    public final IEnergyStorage feStorage;

    public EnergyAdaptorFEtoMJ(IEnergyStorage feStorage) {
        this.feStorage = feStorage;
    }

    public long getPowerRequested() {
        return this.canReceive() ? BCUtils.convertFEtoMJ(Integer.MAX_VALUE) : 0L;
    }

    public long receivePower(long max, boolean simulate) {
        return max - BCUtils.convertFEtoMJ(this.feStorage.receiveEnergy(BCUtils.convertMJtoFE(max), simulate));
    }

    public boolean canReceive() {
        return this.feStorage.canReceive();
    }

    public boolean canConnect(@NotNull IMjConnector iMjConnector) {
        return this.canReceive() || iMjConnector instanceof IMjReceiver && ((IMjReceiver)iMjConnector).canReceive();
    }

    public long getStored() {
        return BCUtils.convertFEtoMJ(this.feStorage.getEnergyStored());
    }

    public long getCapacity() {
        return BCUtils.convertFEtoMJ(this.feStorage.getMaxEnergyStored());
    }

    public long extractPower(long min, long max, boolean simulate) {
        long canExtract = BCUtils.convertFEtoMJ(this.feStorage.extractEnergy(BCUtils.convertMJtoFE(max), true));
        if (canExtract < min) {
            return 0L;
        }
        return BCUtils.convertFEtoMJ(this.feStorage.extractEnergy(BCUtils.convertMJtoFE(max), simulate));
    }
}

