/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.MTEPatchesMod;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mods.railcraft.common.blocks.multi.TileMultiBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RCMultiblockPatch {
    public Set<Chunk> markedChunks = new HashSet<Chunk>();

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent event) {
        if (!MTEPatchesConfig.railcraft.multiblockSyncFix) {
            return;
        }
        Chunk chunk = event.getChunkInstance();
        RCMultiblockPatch patch = new RCMultiblockPatch(chunk);
        patch.updateRecursive(chunk);
        if (!patch.markedChunks.isEmpty()) {
            MTEPatchesMod.logDebug("Marked chunks: {}", patch.markedChunks.toString());
        }
    }

    private RCMultiblockPatch(Chunk chunk) {
    }

    private void updateNeighborsForMultiblock(Chunk chunk) {
        Map tileentities = chunk.func_177434_r();
        World world = chunk.func_177412_p();
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        boolean hasUpdateTile = false;
        boolean updateWest = false;
        boolean updateEast = false;
        boolean updateNorth = false;
        boolean updateSouth = false;
        for (BlockPos pos : tileentities.keySet()) {
            TileEntity te = (TileEntity)tileentities.get(pos);
            if (!(te instanceof TileMultiBlock)) continue;
            hasUpdateTile = true;
            int localX = pos.func_177958_n() & 0xF;
            int localZ = pos.func_177952_p() & 0xF;
            if (localX == 0) {
                updateWest = true;
            } else if (localX == 15) {
                updateEast = true;
            }
            if (localZ == 0) {
                updateNorth = true;
                continue;
            }
            if (localZ != 15) continue;
            updateSouth = true;
        }
        if (hasUpdateTile) {
            if (updateWest) {
                this.updateRecursive(world.func_72964_e(chunkX - 1, chunkZ));
            }
            if (updateEast) {
                this.updateRecursive(world.func_72964_e(chunkX + 1, chunkZ));
            }
            if (updateNorth) {
                this.updateRecursive(world.func_72964_e(chunkX, chunkZ - 1));
            }
            if (updateSouth) {
                this.updateRecursive(world.func_72964_e(chunkX, chunkZ + 1));
            }
        }
    }

    private void updateRecursive(Chunk chunk) {
        if (this.markedChunks.contains(chunk)) {
            return;
        }
        RCMultiblockPatch.updateTilesInChunk(chunk);
        this.markedChunks.add(chunk);
        this.updateNeighborsForMultiblock(chunk);
    }

    private static void updateTilesInChunk(Chunk chunk) {
        if (!chunk.func_177410_o()) {
            return;
        }
        Map tileentities = chunk.func_177434_r();
        for (BlockPos pos : tileentities.keySet()) {
            TileEntity te = (TileEntity)tileentities.get(pos);
            if (!(te instanceof TileMultiBlock)) continue;
            TileMultiBlock multiBlock = (TileMultiBlock)te;
            multiBlock.onLoad();
            multiBlock.sendUpdateToClient();
        }
    }
}

