/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.buildcraft;

import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.transport.tile.TilePipeHolder;
import io.bluebeaker.mtepatches.LoadedModChecker;
import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.buildcraft.EnergyAdaptorProviderFEtoMJ;
import io.bluebeaker.mtepatches.buildcraft.EnergyAdaptorProviderMJtoFE;
import io.bluebeaker.mtepatches.buildcraft.ItemTransactorAdaptor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCCapabilityAdapter {
    public static BCCapabilityAdapter INSTANCE = new BCCapabilityAdapter();
    private ResourceLocation itemCap = new ResourceLocation("mtepatches", "BC_itemCapability");
    private ResourceLocation powerMJtoFE = new ResourceLocation("mtepatches", "BC_MJtoFE");
    private ResourceLocation powerFEtoMJ = new ResourceLocation("mtepatches", "BC_FEtoMJ");

    private BCCapabilityAdapter() {
    }

    public void init() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void subscribe(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tile = (TileEntity)event.getObject();
        if (MTEPatchesConfig.buildcraft.itemPipeAcceptEjection && LoadedModChecker.buildcrafttransport.isLoaded() && tile instanceof TilePipeHolder) {
            event.addCapability(this.itemCap, (ICapabilityProvider)new ItemTransactorAdaptor((TilePipeHolder)tile));
        }
        if (MTEPatchesConfig.buildcraft.mjToForgeEnergy) {
            if (tile instanceof TileBC_Neptune) {
                event.addCapability(this.powerMJtoFE, (ICapabilityProvider)new EnergyAdaptorProviderMJtoFE((TileBC_Neptune)tile));
            } else {
                event.addCapability(this.powerFEtoMJ, (ICapabilityProvider)new EnergyAdaptorProviderFEtoMJ(tile));
            }
        }
    }
}

