/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.buildcraft;

import buildcraft.api.mj.MjAPI;
import io.bluebeaker.mtepatches.buildcraft.CachingAdaptorProvider;
import io.bluebeaker.mtepatches.buildcraft.EnergyAdaptorFEtoMJ;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyAdaptorProviderFEtoMJ
extends CachingAdaptorProvider<IEnergyStorage, EnergyAdaptorFEtoMJ>
implements ICapabilityProvider {
    public final TileEntity tile;

    public EnergyAdaptorProviderFEtoMJ(TileEntity tile) {
        this.tile = tile;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.shouldAddCapability(capability, facing)) {
            return this.tile.hasCapability(CapabilityEnergy.ENERGY, facing);
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        IEnergyStorage capability1;
        if (this.shouldAddCapability(capability, facing) && (capability1 = (IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, facing)) != null) {
            return (T)this.getOrCreateAdaptor(capability1, facing);
        }
        return null;
    }

    @Override
    protected EnergyAdaptorFEtoMJ createNewAdaptor(IEnergyStorage cap) {
        return new EnergyAdaptorFEtoMJ(cap);
    }

    protected boolean shouldAddCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == MjAPI.CAP_RECEIVER || capability == MjAPI.CAP_CONNECTOR || capability == MjAPI.CAP_PASSIVE_PROVIDER || capability == MjAPI.CAP_READABLE;
    }
}

