/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.buildcraft;

import buildcraft.transport.pipe.flow.PipeFlowPower;
import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.mixin.buildcraft.AccessorPipeFlowPower;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PipeFlowPower.Section.class}, remap=false)
public class MixinPipeFlowPowerSection {
    @Final
    @Shadow
    PipeFlowPower this$0;
    @Shadow
    long debugPowerOffered;
    @Shadow
    public long internalNextPower;
    @Unique
    private long mte_patches$powerLimitRemaining = 0L;

    @Inject(method={"receivePowerInternal(J)J"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyPowerCap(long sent, CallbackInfoReturnable<Long> cir) {
        if (!MTEPatchesConfig.buildcraft.limitPipePower || sent == 0L) {
            return;
        }
        long cappedPower = Math.min(Math.min(this.mte_patches$powerLimitRemaining, sent), ((AccessorPipeFlowPower)this.this$0).getMaxPower() * 20L - this.internalNextPower);
        this.mte_patches$powerLimitRemaining -= cappedPower;
        this.debugPowerOffered += cappedPower;
        this.internalNextPower += cappedPower;
        cir.setReturnValue((Object)(sent - cappedPower));
    }

    @Inject(method={"step()V"}, at={@At(value="HEAD")})
    private void step(CallbackInfo ci) {
        if (!MTEPatchesConfig.buildcraft.limitPipePower) {
            return;
        }
        long maxPower = ((AccessorPipeFlowPower)this.this$0).getMaxPower();
        this.mte_patches$powerLimitRemaining = Math.min(maxPower * 20L, this.mte_patches$powerLimitRemaining + maxPower);
    }
}

