/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.railcraft;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.MTEPatchesMod;
import mods.railcraft.common.blocks.tracks.BlockTrackTile;
import mods.railcraft.common.blocks.tracks.outfitted.BlockTrackOutfitted;
import mods.railcraft.common.blocks.tracks.outfitted.TileTrackOutfitted;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockTrackOutfitted.class}, remap=false)
public abstract class MixinBlockTrackOutfitted
extends BlockTrackTile<TileTrackOutfitted> {
    @Unique
    ThreadLocal<Boolean> mtepatches_isBeingRemovedByPlayer = ThreadLocal.withInitial(() -> false);

    @Inject(method={"getDrops(Lnet/minecraft/util/NonNullList;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)V"}, at={@At(value="HEAD")})
    public void addMissingTrack(NonNullList<ItemStack> items, IBlockAccess world, BlockPos pos, IBlockState state, int fortune, CallbackInfo ci) {
        if (!MTEPatchesConfig.railcraft.outfittedDropsFix || this.mtepatches_isBeingRemovedByPlayer.get().booleanValue()) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        try {
            if (tile instanceof TileTrackOutfitted) {
                ((TileTrackOutfitted)tile).getTrackType().getBaseBlock().getDrops(items, world, pos, state, fortune);
            }
        }
        catch (Exception e) {
            MTEPatchesMod.getLogger().error("Exception in MixinBlockTrackOutfitted:", (Throwable)e);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (MTEPatchesConfig.railcraft.outfittedDropsFix) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            if (world.field_72995_K) {
                return true;
            }
            this.mtepatches_isBeingRemovedByPlayer.set(true);
            this.func_176226_b(world, pos, state, 0);
            boolean result = this.clearBlock(state, world, pos, player);
            this.mtepatches_isBeingRemovedByPlayer.set(false);
            return result;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void breakRail(World world, BlockPos pos) {
        if (!MTEPatchesConfig.railcraft.outfittedDropsFix) {
            super.breakRail(world, pos);
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175655_b(pos, false);
    }
}

