/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.railcraft;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.mixin.railcraft.charge.AccessorChargeGrid;
import io.bluebeaker.mtepatches.mixin.railcraft.charge.AccessorChargeNode;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.IChargeBlock;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.charge.ChargeNetwork;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ChargeDebug {
    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        ChargeNetwork.ChargeNode node;
        if (!MTEPatchesConfig.railcraft.chargeNetworkFixDebug) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = WorldPlugin.getBlockState((IBlockAccess)world, (BlockPos)pos);
        if (state.func_177230_c() instanceof IChargeBlock && (node = (ChargeNetwork.ChargeNode)((IChargeBlock)state.func_177230_c()).getMeterAccess(Charge.distribution, state, world, pos)).isValid() && !node.isGridNull()) {
            for (ChargeNetwork.ChargeNode chargeNode : ((AccessorChargeGrid)node.getGrid()).getChargeNodes()) {
                BlockPos pos1 = ((AccessorChargeNode)chargeNode).getPos();
                ChargeDebug.summonDebugParticle(world, EnumParticleTypes.REDSTONE, pos1);
            }
            ChargeNetwork.ChargeGrid grid = node.getGrid();
            player.func_146105_b((ITextComponent)new TextComponentString("Size=" + grid.size() + ", Grid=" + grid), true);
        }
    }

    public static void summonDebugParticle(World world1, EnumParticleTypes particle, BlockPos pos1, Block block) {
        ChargeDebug.summonDebugParticle(world1, particle, pos1, ItemBlock.func_150898_a((Block)block), 0);
    }

    public static void summonDebugParticle(World world1, EnumParticleTypes particle, BlockPos pos1, Block block, int meta) {
        ChargeDebug.summonDebugParticle(world1, particle, pos1, ItemBlock.func_150898_a((Block)block), meta);
    }

    public static void summonDebugParticle(World world1, EnumParticleTypes particle, BlockPos pos1) {
        if (!MTEPatchesConfig.railcraft.chargeNetworkFixDebug) {
            return;
        }
        if (world1 instanceof WorldServer) {
            ((WorldServer)world1).func_175739_a(particle, (double)pos1.func_177958_n() + 0.5, (double)(pos1.func_177956_o() + 1), (double)pos1.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void summonDebugParticle(World world1, EnumParticleTypes particle, BlockPos pos1, Item item, int meta) {
        if (!MTEPatchesConfig.railcraft.chargeNetworkFixDebug) {
            return;
        }
        int id = Item.field_150901_e.func_148757_b((Object)item);
        if (world1 instanceof WorldServer) {
            ((WorldServer)world1).func_175739_a(particle, (double)pos1.func_177958_n() + 0.5, (double)(pos1.func_177956_o() + 1), (double)pos1.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, 0.0, new int[]{id, meta});
        }
    }
}

