/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.railcraft;

import io.bluebeaker.mtepatches.MTEPatchesConfig;
import java.util.function.Predicate;
import mods.railcraft.common.util.inventory.IInvSlot;
import mods.railcraft.common.util.inventory.IInventoryComposite;
import mods.railcraft.common.util.inventory.InvOp;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryAdaptor;
import mods.railcraft.common.util.inventory.InventoryIterator;
import net.minecraft.item.ItemStack;

public class InventoryUtils {
    public static ItemStack moveStackInternal(IInventoryComposite instance, IInventoryComposite dest, Predicate<ItemStack> filter) {
        return instance.stream().map(src -> InventoryUtils.moveStackInternal(src, dest, filter)).filter(InvTools::nonEmpty).findFirst().orElseGet(InvTools::emptyStack);
    }

    protected static ItemStack moveStackInternal(InventoryAdaptor src, IInventoryComposite dest, Predicate<ItemStack> filter) {
        for (IInvSlot slot : InventoryIterator.get((InventoryAdaptor)src)) {
            if (!slot.hasStack() || !slot.canTakeStackFromSlot() || !slot.matches(filter)) continue;
            ItemStack stackToMove = slot.getStack().func_77946_l();
            if (stackToMove.func_190916_E() > MTEPatchesConfig.railcraft.itemMoveInterval) {
                stackToMove.func_190920_e(MTEPatchesConfig.railcraft.itemMoveInterval);
            }
            ItemStack stackLeft = dest.addStack(stackToMove);
            int movedAmount = stackToMove.func_190916_E() - stackLeft.func_190916_E();
            if (movedAmount <= 0) continue;
            return slot.removeFromSlot(movedAmount, InvOp.EXECUTE);
        }
        return InvTools.emptyStack();
    }

    public static int getCooldownFromMovedStack(ItemStack stack) {
        return (stack.func_190926_b() ? MTEPatchesConfig.railcraft.itemMoveInterval : Math.min(MTEPatchesConfig.railcraft.itemMoveInterval, stack.func_190916_E())) - 1;
    }
}

