/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches.mixin.railcraft.charge;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableSet;
import com.llamalad7.mixinextras.sugar.Local;
import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.MTEPatchesMod;
import io.bluebeaker.mtepatches.mixin.railcraft.charge.AccessorChargeGrid;
import io.bluebeaker.mtepatches.mixin.railcraft.charge.AccessorChargeNode;
import io.bluebeaker.mtepatches.railcraft.ChargeDebug;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import mods.railcraft.api.charge.IChargeBlock;
import mods.railcraft.common.util.charge.ChargeNetwork;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChargeNetwork.class}, remap=false)
public abstract class MixinChargeNetwork {
    @Shadow
    @Final
    private Map<BlockPos, ChargeNetwork.ChargeNode> nodes;
    @Shadow
    @Final
    private WeakReference<World> world;
    @Shadow
    @Final
    private ChargeNetwork.ChargeGrid NULL_GRID;
    @Shadow
    @Final
    private Set<ChargeNetwork.ChargeGrid> grids;
    @Unique
    private final Set<ChargeNetwork.ChargeGrid> mte_patches$changedGrids = new HashSet<ChargeNetwork.ChargeGrid>();
    @Unique
    private final Set<BlockPos> mte_patches$destroyedUpdatePos = new HashSet<BlockPos>();
    @Unique
    private final Set<BlockPos> mte_patches$addNodeUpdated = new HashSet<BlockPos>();
    @Unique
    private final Set<BlockPos> mte_patches$lastUpdatedBlocks = new HashSet<BlockPos>();
    @Unique
    int mte_patches$loopcounter = 0;

    @Shadow
    protected abstract void forConnections(BlockPos var1, BiConsumer<BlockPos, IBlockState> var2);

    @Shadow
    public abstract ChargeNetwork.ChargeGrid grid(BlockPos var1);

    @Shadow
    public abstract boolean addNode(BlockPos var1, IBlockState var2);

    @Shadow
    @Nullable
    protected abstract IChargeBlock.ChargeSpec getChargeSpec(IBlockState var1, BlockPos var2);

    @Shadow
    public abstract void removeNode(BlockPos var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void afterAddedNodes(CallbackInfo ci, @Local(ordinal=0) Set<BlockPos> added) {
        if (!MTEPatchesConfig.railcraft.chargeNetworkFix) {
            return;
        }
        if (this.mte_patches$changedGrids.isEmpty() && this.mte_patches$destroyedUpdatePos.isEmpty() && this.mte_patches$addNodeUpdated.isEmpty() && this.mte_patches$lastUpdatedBlocks.isEmpty()) {
            this.mte_patches$loopcounter = 0;
        } else {
            ++this.mte_patches$loopcounter;
            if (this.mte_patches$loopcounter == 500) {
                MTEPatchesMod.getLogger().warn("Charge Network Patch has kept running for {} ticks, maybe there's something keeps updating charge blocks, or problems in the code?", (Object)this.mte_patches$loopcounter);
            }
            if (this.mte_patches$loopcounter >= 1000) {
                MTEPatchesMod.getLogger().warn("Charge Network Patch has kept running for {} ticks, force cleaning...", (Object)this.mte_patches$loopcounter);
                this.mte_patches$changedGrids.clear();
                this.mte_patches$destroyedUpdatePos.clear();
                this.mte_patches$addNodeUpdated.clear();
                this.mte_patches$lastUpdatedBlocks.clear();
            }
        }
        World world1 = (World)this.world.get();
        if (world1 == null) {
            return;
        }
        for (ChargeNetwork.ChargeGrid grid1 : this.mte_patches$changedGrids) {
            if (((AccessorChargeGrid)grid1).getInvalid()) continue;
            HashMap blockStateMap = new HashMap();
            for (ChargeNetwork.ChargeNode chargeNode : grid1) {
                this.forConnections(((AccessorChargeNode)chargeNode).getPos(), blockStateMap::put);
            }
            for (BlockPos pos2 : blockStateMap.keySet()) {
                IBlockState state = (IBlockState)blockStateMap.get(pos2);
                Block block = state.func_177230_c();
                if (!(block instanceof IChargeBlock)) continue;
                ChargeNetwork.ChargeNode node2 = this.nodes.get(pos2);
                if (node2 != null) {
                    ChargeNetwork.ChargeGrid grid2 = node2.getGrid();
                    if (grid1 == grid2) {
                        ChargeDebug.summonDebugParticle(world1, EnumParticleTypes.BLOCK_CRACK, pos2, Blocks.field_190989_dx);
                        continue;
                    }
                    if (grid2.isEmpty()) {
                        grid1.add(node2);
                        this.grids.remove(grid2);
                    }
                    for (ChargeNetwork.ChargeNode chargeNode : grid2) {
                        BlockPos pos3 = ((AccessorChargeNode)chargeNode).getPos();
                        ChargeDebug.summonDebugParticle(world1, EnumParticleTypes.BLOCK_CRACK, pos3, Blocks.field_150340_R);
                    }
                    grid1.addAll((Collection)grid2);
                    ((AccessorChargeGrid)grid2).invokeDestroy(false);
                    BlockPos pos = ((AccessorChargeNode)node2).getPos();
                    ChargeDebug.summonDebugParticle(world1, EnumParticleTypes.VILLAGER_HAPPY, pos);
                } else {
                    ChargeDebug.summonDebugParticle(world1, EnumParticleTypes.BLOCK_CRACK, pos2, Blocks.field_150475_bE);
                }
                this.addNode(pos2, state);
            }
        }
        this.mte_patches$changedGrids.clear();
        this.mte_patches$updateAddedConnections(world1);
        this.mte_patches$updateRemovedConnections(world1);
        this.grids.removeIf(ForwardingCollection::isEmpty);
    }

    @Unique
    private void mte_patches$updateAddedConnections(World world1) {
        this.mte_patches$addNodeUpdated.removeAll(this.mte_patches$lastUpdatedBlocks);
        for (BlockPos pos3 : this.mte_patches$addNodeUpdated) {
            IBlockState state = world1.func_180495_p(pos3);
            Block block = state.func_177230_c();
            if (!(block instanceof IChargeBlock)) continue;
            ChargeDebug.summonDebugParticle(world1, EnumParticleTypes.WATER_SPLASH, pos3);
            this.addNode(pos3, state);
        }
        this.mte_patches$lastUpdatedBlocks.clear();
        this.mte_patches$addNodeUpdated.clear();
    }

    @Unique
    private void mte_patches$updateRemovedConnections(World world1) {
        for (BlockPos updatePos : ImmutableSet.copyOf(this.mte_patches$destroyedUpdatePos)) {
            ChargeNetwork.ChargeNode node = this.nodes.remove(updatePos);
            if (node == null) continue;
            ((AccessorChargeNode)node).setInvalid(true);
            this.addNode(updatePos, world1.func_180495_p(updatePos));
        }
        this.mte_patches$destroyedUpdatePos.clear();
    }

    @Inject(method={"addNodeImpl"}, at={@At(value="HEAD")})
    private void afterAddNode(BlockPos pos, ChargeNetwork.ChargeNode node, CallbackInfo ci) {
        if (!MTEPatchesConfig.railcraft.chargeNetworkFix) {
            return;
        }
        this.mte_patches$lastUpdatedBlocks.add(pos);
        this.mte_patches$changedGrids.add(node.getGrid());
        this.forConnections(pos, (pos2, state) -> {
            this.mte_patches$addNodeUpdated.add((BlockPos)pos2);
            ChargeDebug.summonDebugParticle((World)this.world.get(), EnumParticleTypes.BLOCK_CRACK, pos, Blocks.field_190983_dr);
        });
    }

    @Inject(method={"removeNodeImpl"}, at={@At(value="HEAD")})
    private void beforeRemoveNode(BlockPos pos, CallbackInfo ci) {
        if (!MTEPatchesConfig.railcraft.chargeNetworkFix) {
            return;
        }
        if (this.mte_patches$lastUpdatedBlocks.contains(pos)) {
            return;
        }
        this.mte_patches$lastUpdatedBlocks.add(pos);
        ChargeNetwork.ChargeNode chargeNode = this.nodes.get(pos);
        if (chargeNode == null) {
            return;
        }
        World world1 = (World)this.world.get();
        if (world1 == null) {
            return;
        }
        IChargeBlock.ChargeSpec chargeSpec = chargeNode.getChargeSpec();
        ForwardingMap connectionMap = (ForwardingMap)ChargeNetwork.CONNECTION_MAPS.get(chargeSpec.getConnectType());
        connectionMap.forEach((offset, types) -> {
            BlockPos pos1 = pos.func_177971_a(offset);
            this.mte_patches$destroyedUpdatePos.add(pos1);
        });
    }

    @Inject(method={"needsNode"}, at={@At(value="RETURN")}, cancellable=true)
    public void needsNodeExtra(BlockPos pos, IChargeBlock.ChargeSpec chargeSpec, CallbackInfoReturnable<Boolean> cir, @Local ChargeNetwork.ChargeNode node) {
        if (!MTEPatchesConfig.railcraft.chargeNetworkFix) {
            return;
        }
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (node.getGrid().isNull() || node.getGrid().isEmpty() || !node.getGrid().contains((Object)node)) {
            cir.setReturnValue((Object)true);
        }
    }
}

