/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mtepatches;

import io.bluebeaker.mtepatches.LoadedModChecker;
import io.bluebeaker.mtepatches.MTEPatchesConfig;
import io.bluebeaker.mtepatches.RCMultiblockPatch;
import io.bluebeaker.mtepatches.buildcraft.BCCapabilityAdapter;
import io.bluebeaker.mtepatches.buildcraft.BCUtils;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.Logger;

@Mod(modid="mtepatches", name="MTE Patches", version="1.6.0", acceptableRemoteVersions="*")
public class MTEPatchesMod {
    public static final String MODID = "mtepatches";
    public static final String NAME = "MTE Patches";
    public static final String VERSION = "1.6.0";
    public MinecraftServer server;
    private static Logger logger;

    public MTEPatchesMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (LoadedModChecker.buildcraftcore.isLoaded()) {
            BCCapabilityAdapter.INSTANCE.init();
            MinecraftForge.EVENT_BUS.register((Object)BCCapabilityAdapter.INSTANCE);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        for (LoadedModChecker checker : LoadedModChecker.values()) {
            MTEPatchesMod.getLogger().info("Mod '{}' loaded: {}", (Object)checker.modid, (Object)checker.isLoaded());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (LoadedModChecker.buildcraftcore.isLoaded()) {
            BCUtils.updateValues();
        }
        if (LoadedModChecker.railcraft.isLoaded()) {
            ComparableVersion rcVersion = new ComparableVersion(LoadedModChecker.railcraft.getVersion());
            int compared = rcVersion.compareTo(new ComparableVersion("12.1.0"));
            if (compared < 0) {
                try {
                    Class.forName("mods.railcraft.common.blocks.multi.TileMultiBlock");
                    MinecraftForge.EVENT_BUS.register(RCMultiblockPatch.class);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Could not load RCMultiblockPatch: ", (Throwable)e);
                }
            } else {
                logger.info("RCMultiblockPatch is not needed for Railcraft version {}, not loading it", (Object)rcVersion);
            }
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        this.server = event.getServer();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            if (LoadedModChecker.buildcraftcore.isLoaded()) {
                BCUtils.updateValues();
            }
        }
    }

    @Nullable
    public static Logger getLogger() {
        return logger;
    }

    public static void logInfo(String log) {
        logger.info(log);
    }

    public static void logDebug(String log, Object ... params) {
        if (MTEPatchesConfig.debugOutput) {
            logger.info(log, params);
        }
    }
}

