package eva.lcp.mixin;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.shapes.StaircaseUpWalker;
import com.iamkaf.liteminer.shapes.Walker;
import com.iamkaf.liteminer.tags.TagHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

import static eva.lcp.util.ConfigHolder.isUsable;

@Mixin(value = StaircaseUpWalker.class, remap = false)
public abstract class StaircaseUpWalkerMixin implements Walker {
    @Shadow
    public final Set<class_2338> VISITED = new HashSet<>();

    @Inject(
            method = "searchBlocks",
            at = @At("HEAD"),
            cancellable = true
    )
    private void searchBlocksBetter(
            class_1657 player,
            class_1937 level,
            class_2338 myPos,
            class_2338 absoluteOrigin,
            HashSet<class_2338> blocksToCollapse,
            class_2248 originBlock,
            class_2350 direction,
            CallbackInfo ci
    ) {
        if (!isUsable()) return;
        if (this.VISITED.size() < Liteminer.CONFIG.blockBreakLimit.get()) {
            if (!this.VISITED.contains(myPos)) {
                class_2680 state = level.method_8320(myPos);
                if (!state.method_27852(class_2246.field_10124) && !TagHelper.isExcludedBlock(state)) {
                    for(class_2338 cursor = myPos; blocksToCollapse.size() < Liteminer.CONFIG.blockBreakLimit.get(); cursor = cursor.method_10093(direction).method_10084()) {

                        boolean shouldMineCursor = this.shouldMine(player, level, cursor);
                        boolean shouldMineBelowCursor = this.shouldMine(player, level, cursor.method_10074());
                        boolean shouldMineAboveCursor = this.shouldMine(player, level, cursor.method_10084());

                        if (!(shouldMineCursor || shouldMineBelowCursor || shouldMineAboveCursor)) {
                            break;
                        }

                        if (blocksToCollapse.size() >= Liteminer.CONFIG.blockBreakLimit.get()) break;

                        if (shouldMineCursor) {
                            blocksToCollapse.add(cursor);
                        }

                        if (blocksToCollapse.size() >= Liteminer.CONFIG.blockBreakLimit.get()) break;

                        if (shouldMineBelowCursor) {
                            blocksToCollapse.add(cursor.method_10074());
                        }

                        if (blocksToCollapse.size() >= Liteminer.CONFIG.blockBreakLimit.get()) break;

                        if (shouldMineAboveCursor) {
                            blocksToCollapse.add(cursor.method_10084());
                        }

                    }

                    blocksToCollapse.add(myPos);
                }
            }
        }
        ci.cancel();
    }
}
