package eva.lcp.mixin.client;

import com.iamkaf.liteminer.LiteminerClient;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import eva.lcp.mixin.client.access.CyclerSetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static eva.lcp.util.ClientConfigHolder.getIndex;

@Mixin(value = LiteminerClient.class, remap = false)
public class LiteminerClientMixin {
    @Shadow
    private static boolean currentState;

    @Inject(
            method = "onPostTick",
            at = @At(
                    value = "INVOKE",
                    target = "Lcom/iamkaf/liteminer/networking/LiteminerNetwork$Messages$C2SVeinmineKeybindChange;sendToServer()V"
            )
    )
    private static void setIndex(CallbackInfo ci) {
        if (!currentState && getIndex() >= 0)
            ((CyclerSetter) LiteminerClient.shapes).currentIndex(getIndex());
    }

    @ModifyExpressionValue(
            method = "onPostTick",
            at = @At(
                    value = "INVOKE",
                    target = "Lcom/iamkaf/liteminer/shapes/Cycler;getCurrentIndex()I"
            )
    )
    private static int returnIndex(int original) {
        if (!currentState && getIndex() >= 0) return getIndex();
        return original;
    }
}
