/*
 * Decompiled with CFR 0.152.
 */
package com.elijah629.scheduler;

import java.util.ArrayList;
import java.util.List;

public class Scheduler {
    private int ticks = 0;
    private List<Callback> callbacks = new ArrayList<Callback>();

    public void tick() {
        ++this.ticks;
        for (int i = 0; i < this.callbacks.size(); ++i) {
            Callback callback = this.callbacks.get(i);
            if (this.ticks < callback.startTick + callback.time) continue;
            callback.callback.run();
            this.callbacks.remove(i);
        }
    }

    public void add(int time, Runnable callback) {
        this.callbacks.add(new Callback(time, this.ticks, callback));
    }

    private class Callback {
        public final int time;
        public final int startTick;
        public final Runnable callback;

        public Callback(int time, int ticks, Runnable callback) {
            this.time = time;
            this.startTick = ticks;
            this.callback = callback;
        }
    }
}

