/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.quartz.world.level.block;

import com.nemonotfound.nemos.quartz.platform.Services;
import com.nemonotfound.nemos.quartz.world.level.block.QuartzFlowerPot;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.PushReaction;

public class QuartzBlocks {
    public static final Supplier<Block> QUARTZ_PRESSURE_PLATE = QuartzBlocks.registerPressurePlate("quartz_pressure_plate", Blocks.QUARTZ_BLOCK, BlockSetType.STONE, NoteBlockInstrument.BASEDRUM);
    public static final Supplier<Block> QUARTZ_BUTTON = QuartzBlocks.registerButton("quartz_button", BlockSetType.STONE);
    public static final Supplier<Block> CRACKED_QUARTZ_BRICKS = QuartzBlocks.register("cracked_quartz_bricks", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.QUARTZ_BRICKS));
    public static final Supplier<Block> CRACKED_QUARTZ_BRICK_STAIRS = QuartzBlocks.registerStairs("cracked_quartz_brick_stairs", Blocks.QUARTZ_BRICKS);
    public static final Supplier<Block> CRACKED_QUARTZ_BRICK_SLAB = QuartzBlocks.registerSlab("cracked_quartz_brick_slab", Blocks.QUARTZ_BRICKS);
    public static final Supplier<Block> CRACKED_QUARTZ_BRICK_WALL = QuartzBlocks.registerWall("cracked_quartz_brick_wall", Blocks.QUARTZ_BRICKS);
    public static final Supplier<Block> QUARTZ_BRICK_STAIRS = QuartzBlocks.registerStairs("quartz_brick_stairs", Blocks.QUARTZ_BRICKS);
    public static final Supplier<Block> QUARTZ_BRICK_SLAB = QuartzBlocks.registerSlab("quartz_brick_slab", Blocks.QUARTZ_BRICKS);
    public static final Supplier<Block> QUARTZ_BRICK_WALL = QuartzBlocks.registerWall("quartz_brick_wall", Blocks.QUARTZ_BRICKS);
    public static final Supplier<Block> QUARTZ_FLOWER_POT = QuartzBlocks.register("quartz_flower_pot", properties -> new QuartzFlowerPot(Blocks.AIR, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_TORCHFLOWER = QuartzBlocks.register("quartz_potted_torchflower", properties -> new QuartzFlowerPot(Blocks.TORCHFLOWER, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_OAK_SAPLING = QuartzBlocks.register("quartz_potted_oak_sapling", properties -> new QuartzFlowerPot(Blocks.OAK_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_SPRUCE_SAPLING = QuartzBlocks.register("quartz_potted_spruce_sapling", properties -> new QuartzFlowerPot(Blocks.SPRUCE_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_BIRCH_SAPLING = QuartzBlocks.register("quartz_potted_birch_sapling", properties -> new QuartzFlowerPot(Blocks.BIRCH_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_JUNGLE_SAPLING = QuartzBlocks.register("quartz_potted_jungle_sapling", properties -> new QuartzFlowerPot(Blocks.JUNGLE_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_ACACIA_SAPLING = QuartzBlocks.register("quartz_potted_acacia_sapling", properties -> new QuartzFlowerPot(Blocks.ACACIA_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_CHERRY_SAPLING = QuartzBlocks.register("quartz_potted_cherry_sapling", properties -> new QuartzFlowerPot(Blocks.CHERRY_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_DARK_OAK_SAPLING = QuartzBlocks.register("quartz_potted_dark_oak_sapling", properties -> new QuartzFlowerPot(Blocks.DARK_OAK_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_PALE_OAK_SAPLING = QuartzBlocks.register("quartz_potted_pale_oak_sapling", properties -> new QuartzFlowerPot(Blocks.PALE_OAK_SAPLING, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_MANGROVE_PROPAGULE = QuartzBlocks.register("quartz_potted_mangrove_propagule", properties -> new QuartzFlowerPot(Blocks.MANGROVE_PROPAGULE, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_FERN = QuartzBlocks.register("quartz_potted_fern", properties -> new QuartzFlowerPot(Blocks.FERN, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_DANDELION = QuartzBlocks.register("quartz_potted_dandelion", properties -> new QuartzFlowerPot(Blocks.DANDELION, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_POPPY = QuartzBlocks.register("quartz_potted_poppy", properties -> new QuartzFlowerPot(Blocks.POPPY, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_BLUE_ORCHID = QuartzBlocks.register("quartz_potted_blue_orchid", properties -> new QuartzFlowerPot(Blocks.BLUE_ORCHID, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_ALLIUM = QuartzBlocks.register("quartz_potted_allium", properties -> new QuartzFlowerPot(Blocks.ALLIUM, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_AZURE_BLUET = QuartzBlocks.register("quartz_potted_azure_bluet", properties -> new QuartzFlowerPot(Blocks.AZURE_BLUET, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_RED_TULIP = QuartzBlocks.register("quartz_potted_red_tulip", properties -> new QuartzFlowerPot(Blocks.RED_TULIP, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_ORANGE_TULIP = QuartzBlocks.register("quartz_potted_orange_tulip", properties -> new QuartzFlowerPot(Blocks.ORANGE_TULIP, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_WHITE_TULIP = QuartzBlocks.register("quartz_potted_white_tulip", properties -> new QuartzFlowerPot(Blocks.WHITE_TULIP, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_PINK_TULIP = QuartzBlocks.register("quartz_potted_pink_tulip", properties -> new QuartzFlowerPot(Blocks.PINK_TULIP, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_OXEYE_DAISY = QuartzBlocks.register("quartz_potted_oxeye_daisy", properties -> new QuartzFlowerPot(Blocks.OXEYE_DAISY, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_CORNFLOWER = QuartzBlocks.register("quartz_potted_cornflower", properties -> new QuartzFlowerPot(Blocks.CORNFLOWER, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_LILY_OF_THE_VALLEY = QuartzBlocks.register("quartz_potted_lily_of_the_valley", properties -> new QuartzFlowerPot(Blocks.LILY_OF_THE_VALLEY, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_WITHER_ROSE = QuartzBlocks.register("quartz_potted_wither_rose", properties -> new QuartzFlowerPot(Blocks.WITHER_ROSE, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_RED_MUSHROOM = QuartzBlocks.register("quartz_potted_red_mushroom", properties -> new QuartzFlowerPot(Blocks.RED_MUSHROOM, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_BROWN_MUSHROOM = QuartzBlocks.register("quartz_potted_brown_mushroom", properties -> new QuartzFlowerPot(Blocks.BROWN_MUSHROOM, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_DEAD_BUSH = QuartzBlocks.register("quartz_potted_dead_bush", properties -> new QuartzFlowerPot(Blocks.DEAD_BUSH, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_CACTUS = QuartzBlocks.register("quartz_potted_cactus", properties -> new QuartzFlowerPot(Blocks.CACTUS, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_BAMBOO = QuartzBlocks.register("quartz_potted_bamboo", properties -> new QuartzFlowerPot(Blocks.BAMBOO, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_CRIMSON_FUNGUS = QuartzBlocks.register("quartz_potted_crimson_fungus", properties -> new QuartzFlowerPot(Blocks.CRIMSON_FUNGUS, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_WARPED_FUNGUS = QuartzBlocks.register("quartz_potted_warped_fungus", properties -> new QuartzFlowerPot(Blocks.WARPED_FUNGUS, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_CRIMSON_ROOTS = QuartzBlocks.register("quartz_potted_crimson_roots", properties -> new QuartzFlowerPot(Blocks.CRIMSON_ROOTS, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_WARPED_ROOTS = QuartzBlocks.register("quartz_potted_warped_roots", properties -> new QuartzFlowerPot(Blocks.WARPED_ROOTS, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_AZALEA = QuartzBlocks.register("quartz_potted_azalea_bush", properties -> new QuartzFlowerPot(Blocks.AZALEA, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_FLOWERING_AZALEA = QuartzBlocks.register("quartz_potted_flowering_azalea_bush", properties -> new QuartzFlowerPot(Blocks.FLOWERING_AZALEA, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties());
    public static final Supplier<Block> QUARTZ_POTTED_OPEN_EYEBLOSSOM = QuartzBlocks.register("quartz_potted_open_eyeblossom", properties -> new QuartzFlowerPot(Blocks.OPEN_EYEBLOSSOM, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties().randomTicks());
    public static final Supplier<Block> QUARTZ_POTTED_CLOSED_EYEBLOSSOM = QuartzBlocks.register("quartz_potted_closed_eyeblossom", properties -> new QuartzFlowerPot(Blocks.CLOSED_EYEBLOSSOM, (BlockBehaviour.Properties)properties), QuartzBlocks.flowerPotProperties().randomTicks());

    public static void init() {
    }

    private static Supplier<Block> registerStairs(String id, Block baseBlock) {
        return QuartzBlocks.register(id, properties -> new StairBlock(baseBlock.defaultBlockState(), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    private static Supplier<Block> registerSlab(String id, Block baseBlock) {
        return QuartzBlocks.register(id, SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    private static Supplier<Block> registerWall(String id, Block baseBlock) {
        return QuartzBlocks.register(id, WallBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    private static Supplier<Block> registerPressurePlate(String id, Block baseBlock, BlockSetType blockSetType, NoteBlockInstrument noteBlockInstrument) {
        return QuartzBlocks.register(id, properties -> new PressurePlateBlock(blockSetType, properties), BlockBehaviour.Properties.of().mapColor(baseBlock.defaultMapColor()).forceSolidOn().instrument(noteBlockInstrument).noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    }

    private static Supplier<Block> registerButton(String id, BlockSetType blockSetType) {
        return QuartzBlocks.register(id, properties -> new ButtonBlock(blockSetType, 20, properties), QuartzBlocks.buttonProperties());
    }

    private static Supplier<Block> register(String id, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties) {
        return Services.REGISTRY_HELPER.registerBlock(id, blockFunction, properties);
    }

    private static BlockBehaviour.Properties flowerPotProperties() {
        return BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties buttonProperties() {
        return BlockBehaviour.Properties.of().noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY);
    }
}

