/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.quartz.datagen;

import com.nemonotfound.nemos.quartz.client.data.models.model.QuartzModelTemplates;
import com.nemonotfound.nemos.quartz.world.item.QuartzItems;
import com.nemonotfound.nemos.quartz.world.level.block.QuartzBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_807;

public class QuartzModelProvider
extends FabricModelProvider {
    public QuartzModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockModelGenerators) {
        class_4944 quartzBlockTextureMapping = new class_4944().method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)class_2246.field_10153, (String)"_top"));
        this.createPressurePlate(blockModelGenerators, QuartzBlocks.QUARTZ_PRESSURE_PLATE.get(), quartzBlockTextureMapping);
        this.createButton(blockModelGenerators, QuartzBlocks.QUARTZ_BUTTON.get(), quartzBlockTextureMapping);
        class_4910.class_4912 quartzBricksTexturePool = blockModelGenerators.method_25650(class_2246.field_23868);
        quartzBricksTexturePool.method_25725(QuartzBlocks.QUARTZ_BRICK_STAIRS.get());
        quartzBricksTexturePool.method_25724(QuartzBlocks.QUARTZ_BRICK_SLAB.get());
        quartzBricksTexturePool.method_25720(QuartzBlocks.QUARTZ_BRICK_WALL.get());
        class_4910.class_4912 crackedQuartzBricksTexturePool = blockModelGenerators.method_25650(QuartzBlocks.CRACKED_QUARTZ_BRICKS.get());
        crackedQuartzBricksTexturePool.method_25725(QuartzBlocks.CRACKED_QUARTZ_BRICK_STAIRS.get());
        crackedQuartzBricksTexturePool.method_25724(QuartzBlocks.CRACKED_QUARTZ_BRICK_SLAB.get());
        crackedQuartzBricksTexturePool.method_25720(QuartzBlocks.CRACKED_QUARTZ_BRICK_WALL.get());
        blockModelGenerators.method_25681(QuartzBlocks.QUARTZ_FLOWER_POT.get());
        blockModelGenerators.method_25537(QuartzItems.QUARTZ_FLOWER_POT.get());
        this.createPottedPlant(blockModelGenerators, class_2246.field_42734, QuartzBlocks.QUARTZ_POTTED_TORCHFLOWER.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10394, QuartzBlocks.QUARTZ_POTTED_OAK_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10217, QuartzBlocks.QUARTZ_POTTED_SPRUCE_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10575, QuartzBlocks.QUARTZ_POTTED_BIRCH_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10276, QuartzBlocks.QUARTZ_POTTED_JUNGLE_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10385, QuartzBlocks.QUARTZ_POTTED_ACACIA_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_42727, QuartzBlocks.QUARTZ_POTTED_CHERRY_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10160, QuartzBlocks.QUARTZ_POTTED_DARK_OAK_SAPLING.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_54712, QuartzBlocks.QUARTZ_POTTED_PALE_OAK_SAPLING.get(), PlantType.NOT_TINTED);
        blockModelGenerators.method_25681(QuartzBlocks.QUARTZ_POTTED_MANGROVE_PROPAGULE.get());
        this.createPottedPlant(blockModelGenerators, class_2246.field_22121, QuartzBlocks.QUARTZ_POTTED_CRIMSON_FUNGUS.get(), PlantType.NOT_TINTED);
        this.createNetherRoots(blockModelGenerators, class_2246.field_22125, QuartzBlocks.QUARTZ_POTTED_CRIMSON_ROOTS.get());
        this.createPottedPlant(blockModelGenerators, class_2246.field_22114, QuartzBlocks.QUARTZ_POTTED_WARPED_FUNGUS.get(), PlantType.NOT_TINTED);
        this.createNetherRoots(blockModelGenerators, class_2246.field_22116, QuartzBlocks.QUARTZ_POTTED_WARPED_ROOTS.get());
        this.createPottedPlant(blockModelGenerators, class_2246.field_10112, QuartzBlocks.QUARTZ_POTTED_FERN.get(), PlantType.TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10182, QuartzBlocks.QUARTZ_POTTED_DANDELION.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10449, QuartzBlocks.QUARTZ_POTTED_POPPY.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_55060, QuartzBlocks.QUARTZ_POTTED_OPEN_EYEBLOSSOM.get(), PlantType.EMISSIVE_NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_55061, QuartzBlocks.QUARTZ_POTTED_CLOSED_EYEBLOSSOM.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10086, QuartzBlocks.QUARTZ_POTTED_BLUE_ORCHID.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10226, QuartzBlocks.QUARTZ_POTTED_ALLIUM.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10573, QuartzBlocks.QUARTZ_POTTED_AZURE_BLUET.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10270, QuartzBlocks.QUARTZ_POTTED_RED_TULIP.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10048, QuartzBlocks.QUARTZ_POTTED_ORANGE_TULIP.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10156, QuartzBlocks.QUARTZ_POTTED_WHITE_TULIP.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10315, QuartzBlocks.QUARTZ_POTTED_PINK_TULIP.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10554, QuartzBlocks.QUARTZ_POTTED_OXEYE_DAISY.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_9995, QuartzBlocks.QUARTZ_POTTED_CORNFLOWER.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10548, QuartzBlocks.QUARTZ_POTTED_LILY_OF_THE_VALLEY.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10606, QuartzBlocks.QUARTZ_POTTED_WITHER_ROSE.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10559, QuartzBlocks.QUARTZ_POTTED_RED_MUSHROOM.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10251, QuartzBlocks.QUARTZ_POTTED_BROWN_MUSHROOM.get(), PlantType.NOT_TINTED);
        this.createPottedPlant(blockModelGenerators, class_2246.field_10428, QuartzBlocks.QUARTZ_POTTED_DEAD_BUSH.get(), PlantType.NOT_TINTED);
        blockModelGenerators.method_25681(QuartzBlocks.QUARTZ_POTTED_BAMBOO.get());
        blockModelGenerators.method_25681(QuartzBlocks.QUARTZ_POTTED_CACTUS.get());
        this.createPottedAzalea(blockModelGenerators, QuartzBlocks.QUARTZ_POTTED_AZALEA.get(), class_2246.field_33918);
        this.createPottedAzalea(blockModelGenerators, QuartzBlocks.QUARTZ_POTTED_FLOWERING_AZALEA.get(), class_2246.field_33919);
    }

    public void generateItemModels(class_4915 itemModelGenerators) {
    }

    private void createPressurePlate(class_4910 blockModelGenerators, class_2248 pressurePlateBlock, class_4944 textureMapping) {
        class_807 upVariant = class_4910.method_67835((class_2960)class_4943.field_22906.method_25846(pressurePlateBlock, textureMapping, blockModelGenerators.field_22831));
        class_807 downVariant = class_4910.method_67835((class_2960)class_4943.field_22907.method_25846(pressurePlateBlock, textureMapping, blockModelGenerators.field_22831));
        blockModelGenerators.field_22830.accept(class_4910.method_25673((class_2248)pressurePlateBlock, (class_807)upVariant, (class_807)downVariant));
    }

    private void createButton(class_4910 blockModelGenerators, class_2248 buttonBlock, class_4944 textureMapping) {
        class_807 buttonVariant = class_4910.method_67835((class_2960)class_4943.field_22981.method_25846(buttonBlock, textureMapping, blockModelGenerators.field_22831));
        class_807 pressedButtonVariant = class_4910.method_67835((class_2960)class_4943.field_22982.method_25846(buttonBlock, textureMapping, blockModelGenerators.field_22831));
        blockModelGenerators.field_22830.accept(class_4910.method_25654((class_2248)buttonBlock, (class_807)buttonVariant, (class_807)pressedButtonVariant));
        class_2960 resourcelocation = class_4943.field_22983.method_25846(buttonBlock, textureMapping, blockModelGenerators.field_22831);
        blockModelGenerators.method_25623(buttonBlock, resourcelocation);
    }

    private void createPottedPlant(class_4910 blockModelGenerators, class_2248 plantBlock, class_2248 pottedBlock, PlantType plantType) {
        class_4944 textureMapping = plantType.getPlantTextureMapping(plantBlock);
        class_807 multiVariant = class_4910.method_67835((class_2960)plantType.getCrossPot().method_25846(pottedBlock, textureMapping, blockModelGenerators.field_22831));
        blockModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)pottedBlock, (class_807)multiVariant));
    }

    public final void createPottedAzalea(class_4910 blockModelGenerators, class_2248 quartzPottedAzaleaBlock, class_2248 pottedAzaleaBlock) {
        class_807 multiVariant = quartzPottedAzaleaBlock == QuartzBlocks.QUARTZ_POTTED_FLOWERING_AZALEA ? class_4910.method_67835((class_2960)QuartzModelTemplates.QUARTZ_POTTED_FLOWERING_AZALEA.method_25846(quartzPottedAzaleaBlock, class_4944.method_50028((class_2248)pottedAzaleaBlock), blockModelGenerators.field_22831)) : class_4910.method_67835((class_2960)QuartzModelTemplates.QUARTZ_POTTED_AZALEA.method_25846(quartzPottedAzaleaBlock, class_4944.method_50028((class_2248)pottedAzaleaBlock), blockModelGenerators.field_22831));
        blockModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)quartzPottedAzaleaBlock, (class_807)multiVariant));
    }

    public final void createNetherRoots(class_4910 blockModelGenerators, class_2248 plantBlock, class_2248 pottedPlantBlock) {
        class_4944 textureMapping = class_4944.method_25884((class_2960)class_4944.method_25866((class_2248)plantBlock, (String)"_pot"));
        class_807 multiVariant = class_4910.method_67835((class_2960)PlantType.NOT_TINTED.getCrossPot().method_25846(pottedPlantBlock, textureMapping, blockModelGenerators.field_22831));
        blockModelGenerators.field_22830.accept(class_4910.method_25644((class_2248)pottedPlantBlock, (class_807)multiVariant));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PlantType {
        TINTED(class_4943.field_22922, QuartzModelTemplates.TINTED_QUARTZ_FLOWER_POT_CROSS, false),
        NOT_TINTED(class_4943.field_22921, QuartzModelTemplates.QUARTZ_FLOWER_POT_CROSS, false),
        EMISSIVE_NOT_TINTED(class_4943.field_55180, QuartzModelTemplates.QUARTZ_FLOWER_POT_CROSS_EMISSIVE, true);

        private final class_4942 blockTemplate;
        private final class_4942 flowerPotTemplate;
        private final boolean isEmissive;

        private PlantType(class_4942 blockTemplate, class_4942 flowerPotTemplate, boolean isEmissive) {
            this.blockTemplate = blockTemplate;
            this.flowerPotTemplate = flowerPotTemplate;
            this.isEmissive = isEmissive;
        }

        public class_4942 getCross() {
            return this.blockTemplate;
        }

        public class_4942 getCrossPot() {
            return this.flowerPotTemplate;
        }

        public class_2960 createItemModel(class_4910 generator, class_2248 block) {
            class_1792 item = block.method_8389();
            return this.isEmissive ? generator.method_65414(item, block, "_emissive") : generator.method_65400(item, block);
        }

        public class_4944 getTextureMapping(class_2248 block) {
            return this.isEmissive ? class_4944.method_65299((class_2248)block) : class_4944.method_25877((class_2248)block);
        }

        public class_4944 getPlantTextureMapping(class_2248 block) {
            return this.isEmissive ? class_4944.method_65300((class_2248)block) : class_4944.method_25881((class_2248)block);
        }
    }
}

