/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.quartz.platform;

import com.nemonotfound.nemos.quartz.NeoForgeNemosQuartz;
import com.nemonotfound.nemos.quartz.platform.services.IRegistryHelper;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredHolder;

public class NeoForgeRegistryHelper
implements IRegistryHelper {
    @Override
    public Supplier<Block> registerBlock(String id, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        return NeoForgeNemosQuartz.BLOCKS.register(id, () -> (Block)function.apply(properties.setId(NeoForgeRegistryHelper.createResourceKey(Registries.BLOCK, id))));
    }

    @Override
    public Supplier<Block> registerBlock(String id, Function<BlockBehaviour.Properties, Block> function, Supplier<BlockBehaviour.Properties> properties) {
        return NeoForgeNemosQuartz.BLOCKS.register(id, () -> (Block)function.apply(((BlockBehaviour.Properties)properties.get()).setId(NeoForgeRegistryHelper.createResourceKey(Registries.BLOCK, id))));
    }

    @Override
    public Supplier<Item> registerItem(String id, Function<Item.Properties, Item> function, Item.Properties properties) {
        return NeoForgeNemosQuartz.ITEMS.register(id, () -> (Item)function.apply(properties.setId(NeoForgeRegistryHelper.createResourceKey(Registries.ITEM, id))));
    }

    @Override
    public Supplier<Item> registerItem(String id, Function<Item.Properties, Item> function, Supplier<Item.Properties> properties) {
        return NeoForgeNemosQuartz.ITEMS.register(id, () -> (Item)function.apply(((Item.Properties)properties.get()).setId(NeoForgeRegistryHelper.createResourceKey(Registries.ITEM, id))));
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(String id, EntityType.Builder<T> entityTypeBuilder) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nemos_quartz", (String)id);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resourceLocation);
        return NeoForgeNemosQuartz.ENTITIES.register(id, () -> entityTypeBuilder.build(resourceKey));
    }

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String id, Supplier<T> creativeModeTab) {
        return NeoForgeNemosQuartz.CREATIVE_TABS.register(id, creativeModeTab);
    }

    @Override
    public CreativeModeTab.Builder createCreativeModeTab() {
        return CreativeModeTab.builder();
    }

    @Override
    public Supplier<KeyMapping> registerKeyMapping(KeyMapping keyMapping) {
        return () -> keyMapping;
    }

    @Override
    public Supplier<Holder<Attribute>> registerAttribute(String id, Attribute attribute) {
        DeferredHolder deferredHolder = NeoForgeNemosQuartz.ATTRIBUTE.register(id, () -> attribute);
        return () -> deferredHolder;
    }

    @Override
    public <T> Supplier<DataComponentType<T>> registerDataComponent(String id, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return NeoForgeNemosQuartz.DATA_COMPONENT_TYPE.register(id, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    private static <T> ResourceKey<T> createResourceKey(ResourceKey<Registry<T>> registryResourceKey, String id) {
        return ResourceKey.create(registryResourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nemos_quartz", (String)id));
    }
}

