/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.mystical_missing_items;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MysticalMissingItemsMixinPlugin
implements IMixinConfigPlugin {
    private static Boolean enableRebalance = null;

    public void onLoad(String mixinPackage) {
        enableRebalance = this.readRebalanceConfig();
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (this.isExtendedTierMixin(mixinClassName)) {
            return enableRebalance != null && enableRebalance != false;
        }
        return true;
    }

    private boolean isExtendedTierMixin(String mixinClassName) {
        return mixinClassName.contains("MixinModItems") || mixinClassName.contains("MixinModArmorMaterials");
    }

    private boolean readRebalanceConfig() {
        try {
            Path[] possiblePaths;
            String configFileName = "mystical_missing_items-common.toml";
            for (Path configPath : possiblePaths = new Path[]{Paths.get("config", configFileName), Paths.get("run", "config", configFileName), Paths.get(System.getProperty("user.home"), ".minecraft", "config", configFileName)}) {
                if (!Files.exists(configPath, new LinkOption[0])) continue;
                String content = Files.readString(configPath);
                Pattern pattern = Pattern.compile("enableRebalance\\s*=\\s*(true|false)", 2);
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    return Boolean.parseBoolean(matcher.group(1));
                }
                break;
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

