/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.mystical_missing_items.registry;

import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceCrossbowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceScytheItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceSickleItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRegistry {
    public static final DeferredRegister<ArmorMaterial> MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"mystical_missing_items");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"mystical_missing_items");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mystical_missing_items");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = TABS.register("tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.mystical_missing_items.tab")).icon(() -> ((Item)ModItems.AWAKENED_SUPREMIUM_CHESTPLATE.get()).getDefaultInstance()).build());

    public static void init(IEventBus bus) {
        TABS.register(bus);
        MATERIALS.register(bus);
        ITEMS.register(bus);
    }

    public static DeferredHolder<Item, Item> registerBow(String id, Tier tier, int tinkerable, int slot, float speed, float damage) {
        return ITEMS.register(id, () -> new EssenceBowItem(tier, tinkerable, slot, speed, damage));
    }

    public static DeferredHolder<Item, Item> registerCrossbow(String id, Tier tier, int tinkerable, int slot, float speed, float damage) {
        return ITEMS.register(id, () -> new EssenceCrossbowItem(tier, tinkerable, slot, speed, damage));
    }

    public static DeferredHolder<Item, Item> registerFishingRod(String id, Tier tier, int tinkerable, int slot) {
        return ITEMS.register(id, () -> new EssenceFishingRodItem(tier, tinkerable, slot));
    }

    public static DeferredHolder<Item, Item> registerSickle(String id, Tier tier, int range, ChatFormatting formatting, int tinkerable, int slot) {
        return ITEMS.register(id, () -> new EssenceSickleItem(tier, range, formatting, tinkerable, slot));
    }

    public static DeferredHolder<Item, Item> registerScythe(String id, Tier tier, int range, ChatFormatting formatting, int tinkerable, int slot) {
        return ITEMS.register(id, () -> new EssenceScytheItem(tier, range, formatting, tinkerable, slot));
    }
}

