/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.inheritable_coat_color.registry;

import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.platform.Services;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public final class ICCGeneLoci {
    public static final Holder<GeneLocus> MELANIN_ENZYME = ICCGeneLoci.registerHomologous("melanin_enzyme", 14, 6.25E-4, 0.05);
    public static final Holder<GeneLocus> URANIDIN_ENZYME = ICCGeneLoci.registerLeft("uranidin_enzyme", 3, 0.00175, 0.03125);
    public static final Holder<GeneLocus> MELANIN_METABOLIC_ENZYME = ICCGeneLoci.registerHomologous("melanin_metabolic_enzyme", 5, 2.5E-4, 0.0035);
    public static final Holder<GeneLocus> DILUTION = ICCGeneLoci.registerHomologous("dilution", 19, 0.0015, 0.0035);
    public static final Holder<GeneLocus> PINK = ICCGeneLoci.registerHomologous("pink", 6, 2.5E-4, 2.5E-4);
    public static final Holder<GeneLocus> ABNORMAL = ICCGeneLoci.registerHomologous("abnormal", 7, 3.0E-4, 2.75E-4);
    public static final Holder<GeneLocus> HAIR_LENGTH = ICCGeneLoci.registerHomologous("hair_length", 19, 0.00125, 0.00175);
    public static final Holder<GeneLocus> SRY = ICCGeneLoci.registerRight("sry", 8, 2.5E-4, 2.5E-4);

    private ICCGeneLoci() {
    }

    private static Holder<GeneLocus> registerHomologous(String name, int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return Services.PLATFORM.registerGeneLocus(new ResourceLocation("chromosomelib", name), () -> GeneLocus.homologous((int)index, (double)possibilityOfMutation, (double)possibilityOfCrossingOver));
    }

    private static Holder<GeneLocus> registerLeft(String name, int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return Services.PLATFORM.registerGeneLocus(new ResourceLocation("chromosomelib", name), () -> GeneLocus.left((int)index, (double)possibilityOfMutation, (double)possibilityOfCrossingOver));
    }

    private static Holder<GeneLocus> registerRight(String name, int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return Services.PLATFORM.registerGeneLocus(new ResourceLocation("chromosomelib", name), () -> GeneLocus.right((int)index, (double)possibilityOfMutation, (double)possibilityOfCrossingOver));
    }

    public static void init() {
    }
}

